/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.trino.Session;
import io.trino.cost.StatsAndCosts;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.testing.QueryRunner;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;

public class PlanDeterminismChecker {
    private static final int MINIMUM_SUBSEQUENT_SAME_PLANS = 10;
    private final QueryRunner queryRunner;
    private final Function<String, String> planEquivalenceFunction;

    public PlanDeterminismChecker(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
        this.planEquivalenceFunction = Function.identity();
    }

    public void checkPlanIsDeterministic(@Language(value="SQL") String sql) {
        this.checkPlanIsDeterministic(this.queryRunner.getDefaultSession(), sql);
    }

    public void checkPlanIsDeterministic(Session session, @Language(value="SQL") String sql) {
        String previous = this.planEquivalenceFunction.apply(this.getPlanText(session, sql));
        for (int attempt = 1; attempt < 10; ++attempt) {
            String current = this.planEquivalenceFunction.apply(this.getPlanText(session, sql));
            Assertions.assertThat((String)previous).isEqualTo(current);
        }
    }

    private String getPlanText(Session session, @Language(value="SQL") String sql) {
        return (String)this.queryRunner.inTransaction(session, transactionSession -> {
            Plan plan = this.queryRunner.createPlan(transactionSession, sql);
            return PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (Metadata)this.queryRunner.getPlannerContext().getMetadata(), (FunctionManager)this.queryRunner.getPlannerContext().getFunctionManager(), (StatsAndCosts)plan.getStatsAndCosts(), (Session)transactionSession, (int)0, (boolean)false);
        });
    }
}

