/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public class TieredMergePolicy
extends MergePolicy {
    public static final double DEFAULT_NO_CFS_RATIO = 0.1;
    private int maxMergeAtOnce = 10;
    private long maxMergedSegmentBytes = 0x140000000L;
    private long floorSegmentBytes = 0x200000L;
    private double segsPerTier = 10.0;
    private double forceMergeDeletesPctAllowed = 10.0;
    private double deletesPctAllowed = 20.0;
    private int targetSearchConcurrency = 1;

    public TieredMergePolicy() {
        super(0.1, Long.MAX_VALUE);
    }

    public TieredMergePolicy setMaxMergeAtOnce(int v) {
        if (v < 2) {
            throw new IllegalArgumentException("maxMergeAtOnce must be > 1 (got " + v + ")");
        }
        this.maxMergeAtOnce = v;
        return this;
    }

    public int getMaxMergeAtOnce() {
        return this.maxMergeAtOnce;
    }

    public TieredMergePolicy setMaxMergedSegmentMB(double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("maxMergedSegmentMB must be >=0 (got " + v + ")");
        }
        this.maxMergedSegmentBytes = (v *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v;
        return this;
    }

    public double getMaxMergedSegmentMB() {
        return (double)this.maxMergedSegmentBytes / 1024.0 / 1024.0;
    }

    public TieredMergePolicy setDeletesPctAllowed(double v) {
        if (v < 5.0 || v > 50.0) {
            throw new IllegalArgumentException("indexPctDeletedTarget must be >= 5.0 and <= 50 (got " + v + ")");
        }
        this.deletesPctAllowed = v;
        return this;
    }

    public double getDeletesPctAllowed() {
        return this.deletesPctAllowed;
    }

    public TieredMergePolicy setFloorSegmentMB(double v) {
        if (v <= 0.0) {
            throw new IllegalArgumentException("floorSegmentMB must be > 0.0 (got " + v + ")");
        }
        this.floorSegmentBytes = (v *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v;
        return this;
    }

    public double getFloorSegmentMB() {
        return (double)this.floorSegmentBytes / 1048576.0;
    }

    @Override
    protected long maxFullFlushMergeSize() {
        return this.floorSegmentBytes;
    }

    public TieredMergePolicy setForceMergeDeletesPctAllowed(double v) {
        if (v < 0.0 || v > 100.0) {
            throw new IllegalArgumentException("forceMergeDeletesPctAllowed must be between 0.0 and 100.0 inclusive (got " + v + ")");
        }
        this.forceMergeDeletesPctAllowed = v;
        return this;
    }

    public double getForceMergeDeletesPctAllowed() {
        return this.forceMergeDeletesPctAllowed;
    }

    public TieredMergePolicy setSegmentsPerTier(double v) {
        if (v < 2.0) {
            throw new IllegalArgumentException("segmentsPerTier must be >= 2.0 (got " + v + ")");
        }
        this.segsPerTier = v;
        return this;
    }

    public double getSegmentsPerTier() {
        return this.segsPerTier;
    }

    public TieredMergePolicy setTargetSearchConcurrency(int targetSearchConcurrency) {
        if (targetSearchConcurrency < 1) {
            throw new IllegalArgumentException("targetSearchConcurrency must be >= 1 (got " + targetSearchConcurrency + ")");
        }
        this.targetSearchConcurrency = targetSearchConcurrency;
        return this;
    }

    public int getTargetSearchConcurrency() {
        return this.targetSearchConcurrency;
    }

    private List<SegmentSizeAndDocs> getSortedBySegmentSize(SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        ArrayList<SegmentSizeAndDocs> sortedBySize = new ArrayList<SegmentSizeAndDocs>();
        for (SegmentCommitInfo info : infos) {
            sortedBySize.add(new SegmentSizeAndDocs(info, this.size(info, mergeContext), mergeContext.numDeletesToMerge(info)));
        }
        sortedBySize.sort((o1, o2) -> {
            int cmp = Long.compare(o2.sizeInBytes, o1.sizeInBytes);
            if (cmp == 0) {
                cmp = o1.name.compareTo(o2.name);
            }
            return cmp;
        });
        return sortedBySize;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        Set<SegmentCommitInfo> merging = mergeContext.getMergingSegments();
        long totIndexBytes = 0L;
        long minSegmentBytes = Long.MAX_VALUE;
        int totalDelDocs = 0;
        int totalMaxDoc = 0;
        long mergingBytes = 0L;
        List<SegmentSizeAndDocs> sortedInfos = this.getSortedBySegmentSize(infos, mergeContext);
        Iterator<SegmentSizeAndDocs> iter = sortedInfos.iterator();
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            long segBytes = segSizeDocs.sizeInBytes;
            if (this.verbose(mergeContext)) {
                Object extra;
                Object object = extra = merging.contains(segSizeDocs.segInfo) ? " [merging]" : "";
                if (segBytes >= this.maxMergedSegmentBytes) {
                    extra = (String)extra + " [skip: too large]";
                } else if (segBytes < this.floorSegmentBytes) {
                    extra = (String)extra + " [floored]";
                }
                this.message("  seg=" + this.segString(mergeContext, Collections.singleton(segSizeDocs.segInfo)) + " size=" + String.format(Locale.ROOT, "%.3f", (double)segBytes / 1024.0 / 1024.0) + " MB" + (String)extra, mergeContext);
            }
            if (merging.contains(segSizeDocs.segInfo)) {
                mergingBytes += segSizeDocs.sizeInBytes;
                iter.remove();
                totalMaxDoc += segSizeDocs.maxDoc - segSizeDocs.delCount;
            } else {
                totalDelDocs += segSizeDocs.delCount;
                totalMaxDoc += segSizeDocs.maxDoc;
            }
            minSegmentBytes = Math.min(segBytes, minSegmentBytes);
            totIndexBytes += segBytes;
        }
        assert (totalMaxDoc >= 0);
        assert (totalDelDocs >= 0);
        double totalDelPct = 100.0 * (double)totalDelDocs / (double)totalMaxDoc;
        int allowedDelCount = (int)(this.deletesPctAllowed * (double)totalMaxDoc / 100.0);
        int tooBigCount = 0;
        int concurrencyCount = 0;
        iter = sortedInfos.iterator();
        double allowedSegCount = 0.0;
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            double segDelPct = 100.0 * (double)segSizeDocs.delCount / (double)segSizeDocs.maxDoc;
            if (segSizeDocs.sizeInBytes > this.maxMergedSegmentBytes / 2L && (totalDelPct <= this.deletesPctAllowed || segDelPct <= this.deletesPctAllowed)) {
                iter.remove();
                ++tooBigCount;
                totIndexBytes -= segSizeDocs.sizeInBytes;
                allowedDelCount -= segSizeDocs.delCount;
                continue;
            }
            if (concurrencyCount + tooBigCount >= this.targetSearchConcurrency - 1) continue;
            ++concurrencyCount;
            allowedSegCount += 1.0;
            totIndexBytes -= segSizeDocs.sizeInBytes;
        }
        allowedDelCount = Math.max(0, allowedDelCount);
        int mergeFactor = (int)Math.min((double)this.maxMergeAtOnce, this.segsPerTier);
        long levelSize = Math.max(minSegmentBytes, this.floorSegmentBytes);
        long bytesLeft = totIndexBytes;
        while (true) {
            double segCountLevel;
            if ((segCountLevel = (double)bytesLeft / (double)levelSize) < this.segsPerTier || levelSize == this.maxMergedSegmentBytes) {
                allowedSegCount += Math.ceil(segCountLevel);
                break;
            }
            allowedSegCount += this.segsPerTier;
            bytesLeft = (long)((double)bytesLeft - this.segsPerTier * (double)levelSize);
            levelSize = Math.min(this.maxMergedSegmentBytes, levelSize * (long)mergeFactor);
        }
        allowedSegCount = Math.max(allowedSegCount, this.segsPerTier);
        allowedSegCount = Math.max(allowedSegCount, (double)(this.targetSearchConcurrency - tooBigCount));
        int allowedDocCount = this.getMaxAllowedDocs(totalMaxDoc, totalDelDocs);
        if (this.verbose(mergeContext) && tooBigCount > 0) {
            this.message("  allowedSegmentCount=" + allowedSegCount + " vs count=" + infos.size() + " (eligible count=" + sortedInfos.size() + ") tooBigCount= " + tooBigCount + "  allowedDocCount=" + allowedDocCount + " vs doc count=" + infos.totalMaxDoc(), mergeContext);
        }
        return this.doFindMerges(sortedInfos, this.maxMergedSegmentBytes, mergeFactor, (int)allowedSegCount, allowedDelCount, allowedDocCount, MERGE_TYPE.NATURAL, mergeContext, mergingBytes >= this.maxMergedSegmentBytes);
    }

    private MergePolicy.MergeSpecification doFindMerges(List<SegmentSizeAndDocs> sortedEligibleInfos, long maxMergedSegmentBytes, int mergeFactor, int allowedSegCount, int allowedDelCount, int allowedDocCount, MERGE_TYPE mergeType, MergePolicy.MergeContext mergeContext, boolean maxMergeIsRunning) throws IOException {
        ArrayList<SegmentSizeAndDocs> sortedEligible = new ArrayList<SegmentSizeAndDocs>(sortedEligibleInfos);
        HashMap<SegmentCommitInfo, SegmentSizeAndDocs> segInfosSizes = new HashMap<SegmentCommitInfo, SegmentSizeAndDocs>();
        for (SegmentSizeAndDocs segSizeDocs : sortedEligible) {
            segInfosSizes.put(segSizeDocs.segInfo, segSizeDocs);
        }
        int originalSortedSize = sortedEligible.size();
        if (this.verbose(mergeContext)) {
            this.message("findMerges: " + originalSortedSize + " segments", mergeContext);
        }
        if (originalSortedSize == 0) {
            return null;
        }
        HashSet<SegmentCommitInfo> toBeMerged = new HashSet<SegmentCommitInfo>();
        MergePolicy.MergeSpecification spec = null;
        boolean haveOneLargeMerge = false;
        while (true) {
            Iterator iter = sortedEligible.iterator();
            while (iter.hasNext()) {
                SegmentSizeAndDocs segSizeDocs = (SegmentSizeAndDocs)iter.next();
                if (!toBeMerged.contains(segSizeDocs.segInfo)) continue;
                iter.remove();
            }
            if (this.verbose(mergeContext)) {
                this.message("  allowedSegmentCount=" + allowedSegCount + " vs count=" + originalSortedSize + " (eligible count=" + sortedEligible.size() + ")", mergeContext);
            }
            if (sortedEligible.size() == 0) {
                return spec;
            }
            int remainingDelCount = sortedEligible.stream().mapToInt(c -> c.delCount).sum();
            if (mergeType == MERGE_TYPE.NATURAL && sortedEligible.size() <= allowedSegCount && remainingDelCount <= allowedDelCount) {
                return spec;
            }
            MergeScore bestScore = null;
            ArrayList<SegmentCommitInfo> best = null;
            boolean bestTooLarge = false;
            long bestMergeBytes = 0L;
            for (int startIdx = 0; startIdx < sortedEligible.size(); ++startIdx) {
                long totAfterMergeBytes = 0L;
                ArrayList<SegmentCommitInfo> candidate = new ArrayList<SegmentCommitInfo>();
                boolean hitTooLarge = false;
                long bytesThisMerge = 0L;
                long docCountThisMerge = 0L;
                for (int idx = startIdx; idx < sortedEligible.size() && candidate.size() < mergeFactor && bytesThisMerge < maxMergedSegmentBytes && (bytesThisMerge < this.floorSegmentBytes || docCountThisMerge <= (long)allowedDocCount); ++idx) {
                    SegmentSizeAndDocs segSizeDocs = (SegmentSizeAndDocs)sortedEligible.get(idx);
                    long segBytes = segSizeDocs.sizeInBytes;
                    int segDocCount = segSizeDocs.maxDoc - segSizeDocs.delCount;
                    if (totAfterMergeBytes + segBytes > maxMergedSegmentBytes || totAfterMergeBytes > this.floorSegmentBytes && docCountThisMerge + (long)segDocCount > (long)allowedDocCount) {
                        hitTooLarge |= totAfterMergeBytes + segBytes > maxMergedSegmentBytes;
                        if (candidate.size() != 0) continue;
                        candidate.add(segSizeDocs.segInfo);
                        bytesThisMerge += segBytes;
                        continue;
                    }
                    candidate.add(segSizeDocs.segInfo);
                    bytesThisMerge += segBytes;
                    docCountThisMerge += (long)segDocCount;
                    totAfterMergeBytes += segBytes;
                }
                assert (candidate.size() > 0);
                SegmentSizeAndDocs maxCandidateSegmentSize = (SegmentSizeAndDocs)segInfosSizes.get(candidate.get(0));
                if (!hitTooLarge && mergeType == MERGE_TYPE.NATURAL && (double)bytesThisMerge < (double)maxCandidateSegmentSize.sizeInBytes * 1.5 && (double)maxCandidateSegmentSize.delCount < (double)maxCandidateSegmentSize.maxDoc * this.deletesPctAllowed / 100.0 || candidate.size() == 1 && maxCandidateSegmentSize.delCount == 0) continue;
                if (bestScore != null && !hitTooLarge && candidate.size() < mergeFactor) break;
                MergeScore score = this.score(candidate, hitTooLarge, segInfosSizes);
                if (this.verbose(mergeContext)) {
                    this.message("  maybe=" + this.segString(mergeContext, candidate) + " score=" + score.getScore() + " " + score.getExplanation() + " tooLarge=" + hitTooLarge + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)totAfterMergeBytes / 1024.0 / 1024.0), mergeContext);
                }
                if (bestScore != null && !(score.getScore() < bestScore.getScore()) || hitTooLarge && maxMergeIsRunning) continue;
                best = candidate;
                bestScore = score;
                bestTooLarge = hitTooLarge;
                bestMergeBytes = totAfterMergeBytes;
            }
            if (best == null) {
                return spec;
            }
            if (!haveOneLargeMerge || !bestTooLarge || mergeType == MERGE_TYPE.FORCE_MERGE_DELETES) {
                haveOneLargeMerge |= bestTooLarge;
                if (spec == null) {
                    spec = new MergePolicy.MergeSpecification();
                }
                MergePolicy.OneMerge merge = new MergePolicy.OneMerge(best);
                spec.add(merge);
                if (this.verbose(mergeContext)) {
                    this.message("  add merge=" + this.segString(mergeContext, merge.segments) + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)bestMergeBytes / 1024.0 / 1024.0) + " score=" + String.format(Locale.ROOT, "%.3f", bestScore.getScore()) + " " + bestScore.getExplanation() + (bestTooLarge ? " [max merge]" : ""), mergeContext);
                }
            }
            toBeMerged.addAll(best);
        }
    }

    protected MergeScore score(List<SegmentCommitInfo> candidate, boolean hitTooLarge, Map<SegmentCommitInfo, SegmentSizeAndDocs> segmentsSizes) throws IOException {
        double skew;
        long totBeforeMergeBytes = 0L;
        long totAfterMergeBytes = 0L;
        long totAfterMergeBytesFloored = 0L;
        for (SegmentCommitInfo info : candidate) {
            long segBytes = segmentsSizes.get((Object)info).sizeInBytes;
            totAfterMergeBytes += segBytes;
            totAfterMergeBytesFloored += this.floorSize(segBytes);
            totBeforeMergeBytes += info.sizeInBytes();
        }
        if (hitTooLarge) {
            int mergeFactor = (int)Math.min((double)this.maxMergeAtOnce, this.segsPerTier);
            skew = 1.0 / (double)mergeFactor;
        } else {
            skew = (double)this.floorSize(segmentsSizes.get((Object)candidate.get((int)0)).sizeInBytes) / (double)totAfterMergeBytesFloored;
        }
        double mergeScore = skew;
        mergeScore *= Math.pow(totAfterMergeBytes, 0.05);
        final double nonDelRatio = (double)totAfterMergeBytes / (double)totBeforeMergeBytes;
        final double finalMergeScore = mergeScore *= Math.pow(nonDelRatio, 2.0);
        return new MergeScore(this){

            @Override
            public double getScore() {
                return finalMergeScore;
            }

            @Override
            public String getExplanation() {
                return "skew=" + String.format(Locale.ROOT, "%.3f", skew) + " nonDelRatio=" + String.format(Locale.ROOT, "%.3f", nonDelRatio);
            }
        };
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification spec;
        if (this.verbose(mergeContext)) {
            this.message("findForcedMerges maxSegmentCount=" + maxSegmentCount + " infos=" + this.segString(mergeContext, infos) + " segmentsToMerge=" + String.valueOf(segmentsToMerge), mergeContext);
        }
        List<SegmentSizeAndDocs> sortedSizeAndDocs = this.getSortedBySegmentSize(infos, mergeContext);
        long totalMergeBytes = 0L;
        Set<SegmentCommitInfo> merging = mergeContext.getMergingSegments();
        Iterator<SegmentSizeAndDocs> iter = sortedSizeAndDocs.iterator();
        boolean forceMergeRunning = false;
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            Boolean isOriginal = segmentsToMerge.get(segSizeDocs.segInfo);
            if (isOriginal == null) {
                iter.remove();
                continue;
            }
            if (merging.contains(segSizeDocs.segInfo)) {
                forceMergeRunning = true;
                iter.remove();
                continue;
            }
            totalMergeBytes += segSizeDocs.sizeInBytes;
        }
        long maxMergeBytes = this.maxMergedSegmentBytes;
        if (maxSegmentCount == 1) {
            maxMergeBytes = Long.MAX_VALUE;
        } else if (maxSegmentCount != Integer.MAX_VALUE) {
            maxMergeBytes = Math.max((long)((double)totalMergeBytes / (double)maxSegmentCount), this.maxMergedSegmentBytes);
            maxMergeBytes = (long)((double)maxMergeBytes * 1.25);
        }
        iter = sortedSizeAndDocs.iterator();
        boolean foundDeletes = false;
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            Boolean isOriginal = segmentsToMerge.get(segSizeDocs.segInfo);
            if (segSizeDocs.delCount != 0) {
                if (isOriginal == null || !isOriginal.booleanValue()) continue;
                foundDeletes = true;
                continue;
            }
            if (maxSegmentCount == Integer.MAX_VALUE && isOriginal != null && !isOriginal.booleanValue()) {
                iter.remove();
            }
            if (maxSegmentCount == Integer.MAX_VALUE || segSizeDocs.sizeInBytes < maxMergeBytes) continue;
            iter.remove();
        }
        if (sortedSizeAndDocs.size() == 0) {
            return null;
        }
        if (!foundDeletes) {
            SegmentCommitInfo infoZero = sortedSizeAndDocs.get((int)0).segInfo;
            if (maxSegmentCount != Integer.MAX_VALUE && maxSegmentCount > 1 && sortedSizeAndDocs.size() <= maxSegmentCount || maxSegmentCount == 1 && sortedSizeAndDocs.size() == 1 && (segmentsToMerge.get(infoZero) != null || this.isMerged(infos, infoZero, mergeContext))) {
                if (this.verbose(mergeContext)) {
                    this.message("already merged", mergeContext);
                }
                return null;
            }
        }
        if (this.verbose(mergeContext)) {
            this.message("eligible=" + String.valueOf(sortedSizeAndDocs), mergeContext);
        }
        int startingSegmentCount = sortedSizeAndDocs.size();
        if (forceMergeRunning) {
            return null;
        }
        if (maxSegmentCount == 1 && totalMergeBytes < maxMergeBytes) {
            spec = new MergePolicy.MergeSpecification();
            ArrayList<SegmentCommitInfo> allOfThem = new ArrayList<SegmentCommitInfo>();
            for (SegmentSizeAndDocs segSizeDocs : sortedSizeAndDocs) {
                allOfThem.add(segSizeDocs.segInfo);
            }
            spec.add(new MergePolicy.OneMerge(allOfThem));
            return spec;
        }
        spec = null;
        int index = startingSegmentCount - 1;
        int resultingSegments = startingSegmentCount;
        while (true) {
            int candidateSize;
            ArrayList<SegmentCommitInfo> candidate = new ArrayList<SegmentCommitInfo>();
            long currentCandidateBytes = 0L;
            while (index >= 0 && resultingSegments > maxSegmentCount) {
                SegmentCommitInfo current = sortedSizeAndDocs.get((int)index).segInfo;
                int initialCandidateSize = candidate.size();
                long currentSegmentSize = current.sizeInBytes();
                if (currentCandidateBytes + currentSegmentSize > maxMergeBytes && initialCandidateSize >= 2) break;
                candidate.add(current);
                --index;
                currentCandidateBytes += currentSegmentSize;
                if (initialCandidateSize <= 0) continue;
                --resultingSegments;
            }
            if ((candidateSize = candidate.size()) <= 1 || forceMergeRunning && !((double)currentCandidateBytes > 0.7 * (double)maxMergeBytes)) break;
            MergePolicy.OneMerge merge = new MergePolicy.OneMerge(candidate);
            if (this.verbose(mergeContext)) {
                this.message("add merge=" + this.segString(mergeContext, merge.segments), mergeContext);
            }
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            spec.add(merge);
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        double pctDeletes;
        if (this.verbose(mergeContext)) {
            this.message("findForcedDeletesMerges infos=" + this.segString(mergeContext, infos) + " forceMergeDeletesPctAllowed=" + this.forceMergeDeletesPctAllowed, mergeContext);
        }
        Set<SegmentCommitInfo> merging = mergeContext.getMergingSegments();
        boolean haveWork = false;
        int totalDelCount = 0;
        for (SegmentCommitInfo info : infos) {
            int delCount = mergeContext.numDeletesToMerge(info);
            assert (this.assertDelCount(delCount, info));
            totalDelCount += delCount;
            pctDeletes = 100.0 * (double)delCount / (double)info.info.maxDoc();
            haveWork = haveWork || pctDeletes > this.forceMergeDeletesPctAllowed && !merging.contains(info);
        }
        if (!haveWork) {
            return null;
        }
        List<SegmentSizeAndDocs> sortedInfos = this.getSortedBySegmentSize(infos, mergeContext);
        Iterator<SegmentSizeAndDocs> iter = sortedInfos.iterator();
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            pctDeletes = 100.0 * ((double)segSizeDocs.delCount / (double)segSizeDocs.maxDoc);
            if (!merging.contains(segSizeDocs.segInfo) && !(pctDeletes <= this.forceMergeDeletesPctAllowed)) continue;
            iter.remove();
        }
        if (this.verbose(mergeContext)) {
            this.message("eligible=" + String.valueOf(sortedInfos), mergeContext);
        }
        return this.doFindMerges(sortedInfos, this.maxMergedSegmentBytes, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.getMaxAllowedDocs(infos.totalMaxDoc(), totalDelCount), MERGE_TYPE.FORCE_MERGE_DELETES, mergeContext, false);
    }

    int getMaxAllowedDocs(int totalMaxDoc, int totalDelDocs) {
        return Math.ceilDiv(totalMaxDoc - totalDelDocs, this.targetSearchConcurrency);
    }

    private long floorSize(long bytes) {
        return Math.max(this.floorSegmentBytes, bytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        sb.append("maxMergeAtOnce=").append(this.maxMergeAtOnce).append(", ");
        sb.append("maxMergedSegmentMB=").append((double)this.maxMergedSegmentBytes / 1024.0 / 1024.0).append(", ");
        sb.append("floorSegmentMB=").append((double)this.floorSegmentBytes / 1024.0 / 1024.0).append(", ");
        sb.append("forceMergeDeletesPctAllowed=").append(this.forceMergeDeletesPctAllowed).append(", ");
        sb.append("segmentsPerTier=").append(this.segsPerTier).append(", ");
        sb.append("maxCFSSegmentSizeMB=").append(this.getMaxCFSSegmentSizeMB()).append(", ");
        sb.append("noCFSRatio=").append(this.noCFSRatio).append(", ");
        sb.append("deletesPctAllowed=").append(this.deletesPctAllowed).append(", ");
        sb.append("targetSearchConcurrency=").append(this.targetSearchConcurrency);
        return sb.toString();
    }

    private static class SegmentSizeAndDocs {
        private final SegmentCommitInfo segInfo;
        private final long sizeInBytes;
        private final int delCount;
        private final int maxDoc;
        private final String name;

        SegmentSizeAndDocs(SegmentCommitInfo info, long sizeInBytes, int segDelCount) throws IOException {
            this.segInfo = info;
            this.name = info.info.name;
            this.sizeInBytes = sizeInBytes;
            this.delCount = segDelCount;
            this.maxDoc = info.info.maxDoc();
        }
    }

    private static enum MERGE_TYPE {
        NATURAL,
        FORCE_MERGE,
        FORCE_MERGE_DELETES;

    }

    protected static abstract class MergeScore {
        protected MergeScore() {
        }

        abstract double getScore();

        abstract String getExplanation();
    }
}

