/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.concurrent.atomic.LongAccumulator;

final class MaxScoreAccumulator {
    static final int DEFAULT_INTERVAL = 1023;
    final LongAccumulator acc = new LongAccumulator(MaxScoreAccumulator::maxEncode, Long.MIN_VALUE);
    long modInterval = 1023L;

    MaxScoreAccumulator() {
    }

    private static long maxEncode(long v1, long v2) {
        float score2;
        float score1 = Float.intBitsToFloat((int)(v1 >> 32));
        int cmp = Float.compare(score1, score2 = Float.intBitsToFloat((int)(v2 >> 32)));
        if (cmp == 0) {
            return (int)v1 < (int)v2 ? v1 : v2;
        }
        if (cmp > 0) {
            return v1;
        }
        return v2;
    }

    void accumulate(int docId, float score) {
        assert (docId >= 0 && score >= 0.0f);
        long encode = (long)Float.floatToIntBits(score) << 32 | (long)docId;
        this.acc.accumulate(encode);
    }

    DocAndScore get() {
        long value = this.acc.get();
        if (value == Long.MIN_VALUE) {
            return null;
        }
        float score = Float.intBitsToFloat((int)(value >> 32));
        int docId = (int)value;
        return new DocAndScore(docId, score);
    }

    record DocAndScore(int docId, float score) implements Comparable<DocAndScore>
    {
        @Override
        public int compareTo(DocAndScore o) {
            int cmp = Float.compare(this.score, o.score);
            if (cmp == 0) {
                return Integer.compare(o.docId, this.docId);
            }
            return cmp;
        }
    }
}

