/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.internal;

import io.airlift.compress.v3.internal.NativeSignature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.RecordComponent;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public final class NativeLoader {
    private static final File TEMP_DIR = new File(System.getProperty("aircompressor.tmpdir", System.getProperty("java.io.tmpdir")));
    private static final MethodHandle LINKAGE_ERROR_CONSTRUCTOR;

    private NativeLoader() {
    }

    public static <T> Symbols<T> loadSymbols(String name, Class<T> methodHandlesClass, MethodHandles.Lookup lookup) {
        MethodHandle constructor;
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(methodHandlesClass, "methodHandlesClass is null");
        if (!methodHandlesClass.isRecord()) {
            throw new IllegalArgumentException("methodHandlesClass is not a record class");
        }
        for (RecordComponent recordComponent : methodHandlesClass.getRecordComponents()) {
            if (recordComponent.getAnnotation(NativeSignature.class) != null) continue;
            throw new IllegalArgumentException("methodHandlesClass %s field '%s' is missing @NativeSignature annotation".formatted(methodHandlesClass, recordComponent.getName()));
        }
        try {
            constructor = lookup.findConstructor(methodHandlesClass, MethodType.methodType(Void.TYPE, (Class[])Arrays.stream(methodHandlesClass.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new)));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to find canonical constructor for " + String.valueOf(methodHandlesClass), e);
        }
        try {
            try {
                SymbolLookup symbolLookup = NativeLoader.loadLibrary(name);
                ArrayList<MethodHandle> methodHandles = new ArrayList<MethodHandle>(methodHandlesClass.getRecordComponents().length);
                for (RecordComponent recordComponent : methodHandlesClass.getRecordComponents()) {
                    NativeSignature nativeSignature = recordComponent.getAnnotation(NativeSignature.class);
                    FunctionDescriptor nativeFunctionDescriptor = NativeLoader.getFunctionDescriptor(nativeSignature.returnType(), nativeSignature.argumentTypes());
                    methodHandles.add(symbolLookup.find(nativeSignature.name()).map(memorySegment -> Linker.nativeLinker().downcallHandle((MemorySegment)memorySegment, nativeFunctionDescriptor, Linker.Option.critical((boolean)true))).orElseThrow(() -> new LinkageError("unresolved symbol: " + nativeSignature.name())));
                }
                return new Symbols<T>(Optional.empty(), methodHandlesClass.cast(constructor.invokeWithArguments(methodHandles)));
            }
            catch (LinkageError e) {
                ArrayList<MethodHandle> methodHandles = new ArrayList<MethodHandle>(methodHandlesClass.getRecordComponents().length);
                for (RecordComponent recordComponent : methodHandlesClass.getRecordComponents()) {
                    NativeSignature nativeSignature = recordComponent.getAnnotation(NativeSignature.class);
                    FunctionDescriptor nativeFunctionDescriptor = NativeLoader.getFunctionDescriptor(nativeSignature.returnType(), nativeSignature.argumentTypes());
                    methodHandles.add(NativeLoader.createErrorMethodHandle(name, e, nativeFunctionDescriptor.toMethodType()));
                }
                return new Symbols<T>(Optional.of(e), methodHandlesClass.cast(constructor.invokeWithArguments(methodHandles)));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to create instance of " + String.valueOf(methodHandlesClass), e);
        }
    }

    private static FunctionDescriptor getFunctionDescriptor(Class<?> returnType, Class<?>[] argumentTypes) {
        MemoryLayout[] argumentLayouts = (ValueLayout[])Arrays.stream(argumentTypes).map(NativeLoader::getMemoryLayout).toArray(ValueLayout[]::new);
        if (returnType == Void.TYPE) {
            return FunctionDescriptor.ofVoid(argumentLayouts);
        }
        return FunctionDescriptor.of(NativeLoader.getMemoryLayout(returnType), argumentLayouts);
    }

    private static MethodHandle createErrorMethodHandle(String name, LinkageError linkageError, MethodType methodType) {
        MethodHandle methodHandle = MethodHandles.throwException(methodType.returnType(), LinkageError.class);
        return MethodHandles.foldArguments(methodHandle, MethodHandles.insertArguments(LINKAGE_ERROR_CONSTRUCTOR, 0, name + " native library not loaded: " + linkageError.getMessage(), linkageError));
    }

    private static ValueLayout getMemoryLayout(Class<?> type) {
        if (type == Byte.TYPE) {
            return ValueLayout.JAVA_BYTE;
        }
        if (type == Integer.TYPE) {
            return ValueLayout.JAVA_INT;
        }
        if (type == Long.TYPE) {
            return ValueLayout.JAVA_LONG;
        }
        if (type == MemorySegment.class) {
            return ValueLayout.ADDRESS;
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    public static SymbolLookup loadLibrary(String name) throws LinkageError {
        if (System.getProperty("io.airlift.compress.v3.disable-native") != null) {
            throw new LinkageError("Native library loading is disabled");
        }
        try {
            String libraryPath = NativeLoader.getLibraryPath(name);
            URL url = NativeLoader.class.getResource(libraryPath);
            if (url == null) {
                throw new LinkageError("Library not found: " + libraryPath);
            }
            Path path = NativeLoader.temporaryFile(name, url);
            return SymbolLookup.libraryLookup(path, Arena.ofAuto());
        }
        catch (RuntimeException e) {
            throw new LinkageError("Failed to load library '%s': %s".formatted(name, e.getMessage()), e);
        }
    }

    private static Path temporaryFile(String name, URL url) throws LinkageError {
        try {
            File file = File.createTempFile(name, null, TEMP_DIR);
            file.deleteOnExit();
            try (InputStream in = url.openStream();){
                Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            return file.toPath();
        }
        catch (IOException e) {
            throw new LinkageError("Failed to create temporary file: " + e.getMessage(), e);
        }
    }

    private static String getLibraryPath(String name) {
        return "/aircompressor/" + NativeLoader.getPlatform() + "/" + System.mapLibraryName(name);
    }

    private static String getPlatform() {
        String name;
        name = switch (name = System.getProperty("os.name")) {
            case "Linux" -> "linux";
            case "Mac OS X" -> "macos";
            default -> throw new LinkageError("Unsupported OS platform: " + name);
        };
        String arch = System.getProperty("os.arch");
        if ("x86_64".equals(arch)) {
            arch = "amd64";
        }
        return (name + "-" + arch).replace(' ', '_');
    }

    static {
        try {
            LINKAGE_ERROR_CONSTRUCTOR = MethodHandles.lookup().findConstructor(LinkageError.class, MethodType.methodType(Void.TYPE, String.class, Throwable.class));
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public record Symbols<T>(Optional<LinkageError> linkageError, T symbols) {
    }
}

