/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.zstd;

import io.airlift.compress.v3.hadoop.HadoopInputStream;
import io.airlift.compress.v3.hadoop.HadoopOutputStream;
import io.airlift.compress.v3.hadoop.HadoopStreams;
import io.airlift.compress.v3.zstd.ZstdHadoopInputStream;
import io.airlift.compress.v3.zstd.ZstdHadoopOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public class ZstdHadoopStreams
implements HadoopStreams {
    @Override
    public String getDefaultFileExtension() {
        return ".zst";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.ZStandardCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new ZstdHadoopInputStream(in);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ZstdHadoopOutputStream(out);
    }
}

