/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.internal.coercion;

import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.ThriftCodec;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.codec.metadata.TypeCoercion;
import io.airlift.drift.protocol.TProtocolReader;
import io.airlift.drift.protocol.TProtocolWriter;

@Immutable
public class CoercionThriftCodec<T>
implements ThriftCodec<T> {
    private final ThriftCodec<Object> codec;
    private final TypeCoercion typeCoercion;
    private final ThriftType thriftType;

    public CoercionThriftCodec(ThriftCodec<?> codec, TypeCoercion typeCoercion) {
        this.codec = codec;
        this.typeCoercion = typeCoercion;
        this.thriftType = typeCoercion.getThriftType();
    }

    @Override
    public ThriftType getType() {
        return this.thriftType;
    }

    @Override
    public T read(TProtocolReader protocol) throws Exception {
        Object thriftValue = this.codec.read(protocol);
        return (T)this.typeCoercion.getFromThrift().invoke(null, thriftValue);
    }

    @Override
    public void write(T javaValue, TProtocolWriter protocol) throws Exception {
        Object thriftValue = this.typeCoercion.getToThrift().invoke(null, javaValue);
        this.codec.write(thriftValue, protocol);
    }
}

