/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import io.airlift.drift.codec.ThriftProtocolType;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import io.airlift.drift.codec.metadata.ThriftType;
import io.airlift.drift.codec.metadata.ThriftTypeReference;
import java.lang.reflect.Type;
import java.util.Objects;

public class RecursiveThriftTypeReference
implements ThriftTypeReference {
    private final ThriftCatalog catalog;
    private final Type javaType;
    private final ThriftProtocolType protocolType;

    public RecursiveThriftTypeReference(ThriftCatalog catalog, Type javaType) {
        this.catalog = catalog;
        this.javaType = javaType;
        this.protocolType = catalog.getThriftProtocolType(javaType);
    }

    @Override
    public Type getJavaType() {
        return this.javaType;
    }

    @Override
    public ThriftProtocolType getProtocolType() {
        return this.protocolType;
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    @Override
    public ThriftType get() {
        ThriftType resolvedType = this.catalog.getThriftTypeFromCache(this.javaType);
        if (resolvedType == null) {
            throw new UnsupportedOperationException(String.format("Attempted to resolve a recursive reference to type '%s' before the referenced type was cached (most likely a recursive type support bug)", this.javaType.getTypeName()));
        }
        return resolvedType;
    }

    public String toString() {
        if (this.isResolved()) {
            return "Resolved reference to " + String.valueOf(this.get());
        }
        return "Unresolved reference to ThriftType for " + String.valueOf(this.javaType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveThriftTypeReference that = (RecursiveThriftTypeReference)o;
        return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.javaType, that.javaType);
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.javaType);
    }

    private boolean isResolved() {
        return this.catalog.getThriftTypeFromCache(this.javaType) != null;
    }
}

