/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.Immutable;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.ThriftExtraction;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Objects;

@Immutable
public class ThriftFieldExtractor
implements ThriftExtraction {
    private final short id;
    private final String name;
    private final Field field;
    private final FieldKind fieldKind;
    private final Class<?> type;

    public ThriftFieldExtractor(short fieldId, String fieldName, FieldKind fieldKind, Field field, Type fieldType) {
        this.name = Objects.requireNonNull(fieldName, "name is null");
        this.field = Objects.requireNonNull(field, "field is null");
        this.fieldKind = Objects.requireNonNull(fieldKind, "type is null");
        this.type = TypeToken.of((Type)Objects.requireNonNull(fieldType, "structType is null")).getRawType();
        switch (fieldKind) {
            case THRIFT_FIELD: {
                break;
            }
            case THRIFT_UNION_ID: {
                Preconditions.checkArgument((fieldId == Short.MIN_VALUE ? 1 : 0) != 0, (Object)"fieldId must be Short.MIN_VALUE for thrift_union_id");
            }
        }
        this.id = fieldId;
    }

    @Override
    public FieldKind getFieldKind() {
        return this.fieldKind;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isGeneric() {
        return this.field.getType() != this.field.getGenericType();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (int)this.id).add("name", (Object)this.name).add("field", (Object)this.field).add("fieldKind", (Object)this.fieldKind).add("type", this.type).toString();
    }
}

