/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.codec.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftIdlAnnotation;
import io.airlift.drift.annotations.ThriftStruct;
import io.airlift.drift.codec.metadata.AbstractThriftMetadataBuilder;
import io.airlift.drift.codec.metadata.ConstructorInjection;
import io.airlift.drift.codec.metadata.FieldExtractor;
import io.airlift.drift.codec.metadata.FieldInjection;
import io.airlift.drift.codec.metadata.FieldKind;
import io.airlift.drift.codec.metadata.FieldMetadata;
import io.airlift.drift.codec.metadata.MethodExtractor;
import io.airlift.drift.codec.metadata.ParameterInjection;
import io.airlift.drift.codec.metadata.ThriftCatalog;
import io.airlift.drift.codec.metadata.ThriftConstructorInjection;
import io.airlift.drift.codec.metadata.ThriftExtraction;
import io.airlift.drift.codec.metadata.ThriftFieldExtractor;
import io.airlift.drift.codec.metadata.ThriftFieldInjection;
import io.airlift.drift.codec.metadata.ThriftFieldMetadata;
import io.airlift.drift.codec.metadata.ThriftInjection;
import io.airlift.drift.codec.metadata.ThriftMethodExtractor;
import io.airlift.drift.codec.metadata.ThriftMethodInjection;
import io.airlift.drift.codec.metadata.ThriftParameterInjection;
import io.airlift.drift.codec.metadata.ThriftStructMetadata;
import io.airlift.drift.codec.metadata.ThriftTypeReference;
import io.airlift.drift.codec.metadata.TypeCoercion;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ThriftStructMetadataBuilder
extends AbstractThriftMetadataBuilder {
    public ThriftStructMetadataBuilder(ThriftCatalog catalog, Type structType) {
        super(catalog, structType);
        this.verifyClass(ThriftStruct.class);
        this.normalizeThriftFields(catalog);
    }

    @Override
    protected String extractName() {
        ThriftStruct annotation = this.getStructClass().getAnnotation(ThriftStruct.class);
        if (annotation == null) {
            return this.getStructClass().getSimpleName();
        }
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return this.getStructClass().getSimpleName();
    }

    @Override
    protected Map<String, String> extractStructIdlAnnotations() {
        ThriftStruct annotation = this.getStructClass().getAnnotation(ThriftStruct.class);
        if (annotation == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ThriftIdlAnnotation idlAnnotation : annotation.idlAnnotations()) {
            builder.put((Object)idlAnnotation.key(), (Object)idlAnnotation.value());
        }
        return builder.build();
    }

    @Override
    protected Class<?> extractBuilderClass() {
        ThriftStruct annotation = this.getStructClass().getAnnotation(ThriftStruct.class);
        if (annotation != null && !annotation.builder().equals(Void.TYPE)) {
            return annotation.builder();
        }
        return null;
    }

    @Override
    protected void validateConstructors() {
        if (this.constructorInjections.size() > 1) {
            this.metadataErrors.addError("Multiple constructors are annotated with @ThriftConstructor ", this.constructorInjections);
        }
    }

    @Override
    protected boolean isValidateSetter(Method method) {
        return method.getParameterTypes().length >= 1;
    }

    @Override
    public ThriftStructMetadata build() {
        this.metadataErrors.throwIfHasErrors();
        ThriftMethodInjection builderMethodInjection = this.buildBuilderConstructorInjections();
        ThriftConstructorInjection constructorInjections = this.buildConstructorInjection();
        Iterable<ThriftFieldMetadata> fieldsMetadata = this.buildFieldInjections();
        List<ThriftMethodInjection> methodInjections = this.buildMethodInjections();
        return new ThriftStructMetadata(this.structName, this.extractStructIdlAnnotations(), this.structType, this.builderType, ThriftStructMetadata.MetadataType.STRUCT, Optional.ofNullable(builderMethodInjection), (List<String>)ImmutableList.copyOf((Collection)this.documentation), (List<ThriftFieldMetadata>)ImmutableList.copyOf(fieldsMetadata), Optional.of(constructorInjections), methodInjections);
    }

    private ThriftConstructorInjection buildConstructorInjection() {
        ConstructorInjection injection = (ConstructorInjection)Iterables.getOnlyElement((Iterable)this.constructorInjections);
        return new ThriftConstructorInjection(injection.getConstructor(), ThriftStructMetadataBuilder.buildParameterInjections(injection.getParameters()));
    }

    @Override
    protected ThriftFieldMetadata buildField(Collection<FieldMetadata> input) {
        short id = -1;
        boolean isLegacyId = false;
        Map<String, String> idlAnnotations = null;
        String name = null;
        ThriftField.Requiredness requiredness = ThriftField.Requiredness.UNSPECIFIED;
        boolean recursive = false;
        ThriftTypeReference thriftTypeReference = null;
        ImmutableList.Builder injections = ImmutableList.builder();
        ThriftExtraction extraction = null;
        for (FieldMetadata fieldMetadata : input) {
            id = fieldMetadata.getId();
            isLegacyId = fieldMetadata.isLegacyId();
            name = fieldMetadata.getName();
            recursive = fieldMetadata.isRecursiveReference();
            requiredness = fieldMetadata.getRequiredness();
            idlAnnotations = fieldMetadata.getIdlAnnotations();
            thriftTypeReference = this.catalog.getFieldThriftTypeReference(fieldMetadata);
            if (fieldMetadata instanceof FieldInjection) {
                FieldInjection fieldInjection = (FieldInjection)fieldMetadata;
                injections.add((Object)new ThriftFieldInjection(fieldInjection.getId(), fieldInjection.getName(), fieldInjection.getField(), fieldInjection.getType()));
                continue;
            }
            if (fieldMetadata instanceof ParameterInjection) {
                ParameterInjection parameterInjection = (ParameterInjection)fieldMetadata;
                injections.add((Object)new ThriftParameterInjection(parameterInjection.getId(), parameterInjection.getName(), parameterInjection.getParameterIndex(), fieldMetadata.getJavaType()));
                continue;
            }
            if (fieldMetadata instanceof FieldExtractor) {
                FieldExtractor fieldExtractor = (FieldExtractor)fieldMetadata;
                extraction = new ThriftFieldExtractor(fieldExtractor.getId(), fieldExtractor.getName(), fieldExtractor.getType(), fieldExtractor.getField(), fieldExtractor.getJavaType());
                continue;
            }
            if (!(fieldMetadata instanceof MethodExtractor)) continue;
            MethodExtractor methodExtractor = (MethodExtractor)fieldMetadata;
            extraction = new ThriftMethodExtractor(methodExtractor.getId(), methodExtractor.getName(), methodExtractor.getType(), methodExtractor.getMethod(), methodExtractor.getJavaType());
        }
        TypeCoercion coercion = null;
        if (!thriftTypeReference.isRecursive() && thriftTypeReference.get().isCoerced()) {
            coercion = this.catalog.getDefaultCoercion(thriftTypeReference.get().getJavaType());
        }
        if (recursive && requiredness != ThriftField.Requiredness.OPTIONAL) {
            this.metadataErrors.addError("Struct '%s' field '%s' is recursive but not marked optional", this.structName, name);
        }
        return new ThriftFieldMetadata(id, isLegacyId, recursive, requiredness, idlAnnotations, thriftTypeReference, name, FieldKind.THRIFT_FIELD, (List<ThriftInjection>)injections.build(), Optional.empty(), Optional.empty(), Optional.ofNullable(extraction), Optional.ofNullable(coercion));
    }
}

