/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.NameValidationUtils;
import io.trino.plugin.thrift.api.TrinoThriftDomain;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

@ThriftStruct
public final class TrinoThriftTupleDomain {
    private final Map<String, TrinoThriftDomain> domains;

    @ThriftConstructor
    public TrinoThriftTupleDomain(@Nullable Map<String, TrinoThriftDomain> domains) {
        if (domains != null) {
            for (String name : domains.keySet()) {
                NameValidationUtils.checkValidName(name);
            }
        }
        this.domains = domains;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public Map<String, TrinoThriftDomain> getDomains() {
        return this.domains;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftTupleDomain other = (TrinoThriftTupleDomain)obj;
        return Objects.equals(this.domains, other.domains);
    }

    public int hashCode() {
        return Objects.hashCode(this.domains);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnsWithConstraints", (Object)(this.domains != null ? this.domains.keySet() : ImmutableSet.of())).toString();
    }
}

