/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.command;

import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class Argument<A> {
    private final List<String> names;
    private final Function<List<String>, Tuple2<Optional<A>, List<String>>> parser;
    private final List<Supplier<List<String>>> tabCompleters;

    public static <A> Argument<A> ofUnary(String name, Function<String, Optional<A>> parser, Supplier<List<String>> tabCompleter) {
        return Argument.of(Collections.singletonList(name), args -> {
            ArrayList newArgs = new ArrayList(args);
            String arg = newArgs.size() >= 1 ? (String)newArgs.remove(0) : "";
            return new Tuple2(arg.length() >= 1 ? (Optional)parser.apply(arg) : Optional.empty(), newArgs);
        }, Collections.singletonList(tabCompleter));
    }

    public Argument<Optional<A>> asOptional() {
        return new Argument<Optional<A>>(this.getNames(), args -> this.getParser().apply((List<String>)args).map1(Optional::of), this.getTabCompleters());
    }

    public <B> Argument<B> map(Function<A, B> f) {
        return new Argument<A>(this.getNames(), args -> {
            Tuple2<Optional<A>, List<String>> pair = this.getParser().apply((List<String>)args);
            return pair.map1(a -> a.map(f));
        }, this.getTabCompleters());
    }

    public Argument<A> withName(String name) {
        return this.withNames(Collections.singletonList(name));
    }

    public Argument<A> withTabCompleter(Supplier<List<String>> tabCompleter) {
        return this.withTabCompleters(Collections.singletonList(tabCompleter));
    }

    private Argument(List<String> names, Function<List<String>, Tuple2<Optional<A>, List<String>>> parser, List<Supplier<List<String>>> tabCompleters) {
        this.names = names;
        this.parser = parser;
        this.tabCompleters = tabCompleters;
    }

    public static <A> Argument<A> of(List<String> names, Function<List<String>, Tuple2<Optional<A>, List<String>>> parser, List<Supplier<List<String>>> tabCompleters) {
        return new Argument<A>(names, parser, tabCompleters);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Function<List<String>, Tuple2<Optional<A>, List<String>>> getParser() {
        return this.parser;
    }

    public List<Supplier<List<String>>> getTabCompleters() {
        return this.tabCompleters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        Function<List<String>, Tuple2<Optional<A>, List<String>>> this$parser = this.getParser();
        Function<List<String>, Tuple2<Optional<A>, List<String>>> other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
            return false;
        }
        List<Supplier<List<String>>> this$tabCompleters = this.getTabCompleters();
        List<Supplier<List<String>>> other$tabCompleters = other.getTabCompleters();
        return !(this$tabCompleters == null ? other$tabCompleters != null : !((Object)this$tabCompleters).equals(other$tabCompleters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Argument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        Function<List<String>, Tuple2<Optional<A>, List<String>>> $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        List<Supplier<List<String>>> $tabCompleters = this.getTabCompleters();
        result = result * 59 + ($tabCompleters == null ? 43 : ((Object)$tabCompleters).hashCode());
        return result;
    }

    public String toString() {
        return "Argument(names=" + this.getNames() + ", parser=" + this.getParser() + ", tabCompleters=" + this.getTabCompleters() + ")";
    }

    public Argument<A> withNames(List<String> names) {
        return this.names == names ? this : new Argument<A>(names, this.parser, this.tabCompleters);
    }

    public Argument<A> withParser(Function<List<String>, Tuple2<Optional<A>, List<String>>> parser) {
        return this.parser == parser ? this : new Argument<A>(this.names, parser, this.tabCompleters);
    }

    public Argument<A> withTabCompleters(List<Supplier<List<String>>> tabCompleters) {
        return this.tabCompleters == tabCompleters ? this : new Argument<A>(this.names, this.parser, tabCompleters);
    }
}

