/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.command;

import io.typecraft.command.Argument;
import io.typecraft.command.CommandFailure;
import io.typecraft.command.CommandSpec;
import io.typecraft.command.CommandSuccess;
import io.typecraft.command.CommandTabResult;
import io.typecraft.command.product.ArgumentProduct;
import io.vavr.Function2;
import io.vavr.Function3;
import io.vavr.Function4;
import io.vavr.Function5;
import io.vavr.Function6;
import io.vavr.Function7;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public interface Command<A> {
    public <B> Command<B> map(Function<? super A, ? extends B> var1);

    @SafeVarargs
    public static <A> Mapping<A> mapping(Tuple2<String, Command<? extends A>> ... entries) {
        LinkedHashMap<String, Command> map = new LinkedHashMap<String, Command>();
        for (Tuple2<String, Command<A>> tuple2 : entries) {
            map.put(tuple2._1(), (Command)tuple2._2);
        }
        return new Mapping(map, null);
    }

    public static <A> Parser<A> present(A value) {
        return Command.argument(() -> value);
    }

    public static <T> Parser<T> argument(Supplier<T> f) {
        return new Parser(args -> new Tuple2(Option.some(f.get()), (List)args), Collections.emptyList(), Collections.singletonList(""), "", "");
    }

    public static <T, A> Parser<T> argument(Function<? super A, ? extends T> f, Argument<A> argument) {
        return new Parser(args -> argument.getParser().apply((List<String>)args).map1(aO -> Option.ofOptional(aO).map(f)), argument.getTabCompleters(), argument.getNames(), "", "");
    }

    public static <T, A, B> Parser<T> argument(Function2<? super A, ? super B, ? extends T> f, Argument<A> argA, Argument<B> argB) {
        return Command.argument(tup -> f.apply((Object)tup._1(), (Object)tup._2()), ArgumentProduct.product(argA, argB));
    }

    public static <T, A, B, C> Parser<T> argument(Function3<? super A, ? super B, ? super C, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC) {
        return Command.argument(tup -> f.apply((Object)tup._1(), (Object)tup._2(), (Object)tup._3()), ArgumentProduct.product(argA, argB, argC));
    }

    public static <T, A, B, C, D> Parser<T> argument(Function4<? super A, ? super B, ? super C, ? super D, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC, Argument<D> argD) {
        return Command.argument(tup -> f.apply((Object)tup._1(), (Object)tup._2(), (Object)tup._3(), (Object)tup._4()), ArgumentProduct.product(argA, argB, argC, argD));
    }

    public static <T, A, B, C, D, E> Parser<T> argument(Function5<? super A, ? super B, ? super C, ? super D, ? super E, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC, Argument<D> argD, Argument<E> argE) {
        return Command.argument(tup -> f.apply((Object)tup._1(), (Object)tup._2(), (Object)tup._3(), (Object)tup._4(), (Object)tup._5()), ArgumentProduct.product(argA, argB, argC, argD, argE));
    }

    public static <T, A, B, C, D, E, F> Parser<T> argument(Function6<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC, Argument<D> argD, Argument<E> argE, Argument<F> argF) {
        return Command.argument(tup -> f.apply((Object)tup._1(), (Object)tup._2(), (Object)tup._3(), (Object)tup._4(), (Object)tup._5(), (Object)tup._6()), ArgumentProduct.product(argA, argB, argC, argD, argE, argF));
    }

    public static <T, A, B, C, D, E, F, G> Parser<T> argument(Function7<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? super G, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC, Argument<D> argD, Argument<E> argE, Argument<F> argF, Argument<G> argG) {
        return Command.argument(tup -> f.apply((Object)tup._1(), (Object)tup._2(), (Object)tup._3(), (Object)tup._4(), (Object)tup._5(), (Object)tup._6(), (Object)tup._7()), ArgumentProduct.product(argA, argB, argC, argD, argE, argF, argG));
    }

    public static <K, V> Tuple2<K, V> pair(K key, V value) {
        return new Tuple2<K, V>(key, value);
    }

    public static <A> Either<CommandFailure<A>, CommandSuccess<A>> parse(String[] args, Command<A> command) {
        return Command.parseWithIndex(0, args, command);
    }

    public static <A> Optional<A> parseO(String[] args, Command<A> command) {
        return Command.parse(args, command).toJavaOptional().map(CommandSuccess::getCommand);
    }

    public static <A> Either<CommandFailure<A>, CommandSuccess<A>> parseWithIndex(int index, String[] args, Command<A> command) {
        String argument;
        String string = argument = args.length > index ? args[index] : null;
        if (command instanceof Mapping) {
            Mapping mapCommand = (Mapping)command;
            if (argument == null) {
                Command fallback = mapCommand.getFallback().orElse(null);
                return fallback != null ? Command.parseWithIndex(index + 1, args, fallback) : Either.left(new CommandFailure.FewArguments(args, index, mapCommand));
            }
            Command subCommand = mapCommand.getCommandMap().get(argument);
            return subCommand != null ? Command.parseWithIndex(index + 1, args, subCommand) : Either.left(new CommandFailure.UnknownSubCommand(args, index, mapCommand));
        }
        if (command instanceof Parser) {
            Parser parser = (Parser)command;
            ArrayList<String> list = index <= args.length ? new ArrayList<String>(Arrays.asList(Arrays.copyOfRange(args, index, args.length))) : Collections.emptyList();
            Tuple2 result = parser.getParser().apply((List<String>)list);
            Option aO = (Option)result._1;
            List remainList = (List)result._2;
            Object a = aO.getOrNull();
            int currentIndex = index + list.size() - remainList.size();
            return aO.isDefined() ? Either.right(new CommandSuccess(args, currentIndex, a)) : Either.left(new CommandFailure.ParsingFailure(parser.getNames(), parser));
        }
        throw new UnsupportedOperationException();
    }

    public static <A> CommandTabResult<A> tabComplete(String[] args, Command<A> command) {
        return Command.tabCompleteWithIndex(0, args, command);
    }

    public static <A> CommandTabResult<A> tabCompleteWithIndex(int index, String[] args, Command<A> command) {
        String argument = (args.length > index ? args[index] : "").toLowerCase();
        if (command instanceof Mapping) {
            Mapping mapCommand = (Mapping)command;
            if (index >= args.length - 1) {
                return CommandTabResult.suggestion(mapCommand.getCommandMap().keySet().stream().filter(key -> key.toLowerCase().startsWith(argument)).collect(Collectors.toList()));
            }
            Command subCommand = mapCommand.getCommandMap().get(argument);
            return subCommand != null ? Command.tabCompleteWithIndex(index + 1, args, subCommand) : CommandTabResult.suggestion(Collections.emptyList());
        }
        if (command instanceof Parser) {
            Parser parser = (Parser)command;
            String lastArgument = args.length >= 1 ? args[args.length - 1] : "";
            int pos = args.length - index - 1;
            List<Supplier<List<String>>> tabCompleters = parser.getTabCompleters();
            Supplier<List<String>> tabCompleter = tabCompleters.size() > pos && pos >= 0 ? tabCompleters.get(pos) : null;
            String lowerArgument = lastArgument.toLowerCase();
            List<String> tabComplete = tabCompleter != null ? tabCompleter.get().stream().filter(s -> s.toLowerCase().startsWith(lowerArgument)).collect(Collectors.toList()) : Collections.emptyList();
            return CommandTabResult.suggestion(tabComplete);
        }
        return CommandTabResult.suggestion(Collections.emptyList());
    }

    public static <A> List<Map.Entry<List<String>, Command<A>>> getEntries(Command<A> cmd) {
        if (cmd instanceof Mapping) {
            Mapping mapping = (Mapping)cmd;
            return mapping.getCommandMap().entrySet().stream().flatMap(pair -> {
                List subEntries = Command.getEntries((Command)pair.getValue());
                return subEntries.size() >= 1 ? subEntries.stream().map((? super T subPair) -> new AbstractMap.SimpleEntry(Stream.concat(Stream.of(pair.getKey()), ((List)subPair.getKey()).stream()).collect(Collectors.toList()), subPair.getValue())) : Stream.of(new AbstractMap.SimpleEntry(Collections.singletonList(pair.getKey()), pair.getValue()));
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static <A> CommandSpec getSpec(Command<A> cmd) {
        if (cmd instanceof Parser) {
            Parser parser = (Parser)cmd;
            return CommandSpec.of(parser.getNames(), parser.getDescription(), parser.getPermission());
        }
        return CommandSpec.empty;
    }

    public static class Parser<A>
    implements Command<A> {
        private final Function<List<String>, Tuple2<Option<A>, List<String>>> parser;
        private final List<Supplier<List<String>>> tabCompleters;
        private final List<String> names;
        private final String description;
        private final String permission;

        private Parser(Function<List<String>, Tuple2<Option<A>, List<String>>> parser, List<Supplier<List<String>>> tabCompleters, List<String> names, String description, String permission) {
            this.parser = parser;
            this.tabCompleters = tabCompleters;
            this.names = names;
            this.description = description;
            this.permission = permission;
        }

        @Override
        public <B> Parser<B> map(Function<? super A, ? extends B> f) {
            return new Parser<A>(args -> this.parser.apply((List<String>)args).map1(aO -> aO.map(f)), this.tabCompleters, this.getNames(), this.getDescription(), this.getPermission());
        }

        public Function<List<String>, Tuple2<Option<A>, List<String>>> getParser() {
            return this.parser;
        }

        public List<Supplier<List<String>>> getTabCompleters() {
            return this.tabCompleters;
        }

        public List<String> getNames() {
            return this.names;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPermission() {
            return this.permission;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parser)) {
                return false;
            }
            Parser other = (Parser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Function<List<String>, Tuple2<Option<A>, List<String>>> this$parser = this.getParser();
            Function<List<String>, Tuple2<Option<A>, List<String>>> other$parser = other.getParser();
            if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
                return false;
            }
            List<Supplier<List<String>>> this$tabCompleters = this.getTabCompleters();
            List<Supplier<List<String>>> other$tabCompleters = other.getTabCompleters();
            if (this$tabCompleters == null ? other$tabCompleters != null : !((Object)this$tabCompleters).equals(other$tabCompleters)) {
                return false;
            }
            List<String> this$names = this.getNames();
            List<String> other$names = other.getNames();
            if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$permission = this.getPermission();
            String other$permission = other.getPermission();
            return !(this$permission == null ? other$permission != null : !this$permission.equals(other$permission));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parser;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<List<String>, Tuple2<Option<A>, List<String>>> $parser = this.getParser();
            result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
            List<Supplier<List<String>>> $tabCompleters = this.getTabCompleters();
            result = result * 59 + ($tabCompleters == null ? 43 : ((Object)$tabCompleters).hashCode());
            List<String> $names = this.getNames();
            result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $permission = this.getPermission();
            result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
            return result;
        }

        public String toString() {
            return "Command.Parser(parser=" + this.getParser() + ", tabCompleters=" + this.getTabCompleters() + ", names=" + this.getNames() + ", description=" + this.getDescription() + ", permission=" + this.getPermission() + ")";
        }

        public Parser<A> withParser(Function<List<String>, Tuple2<Option<A>, List<String>>> parser) {
            return this.parser == parser ? this : new Parser<A>(parser, this.tabCompleters, this.names, this.description, this.permission);
        }

        public Parser<A> withTabCompleters(List<Supplier<List<String>>> tabCompleters) {
            return this.tabCompleters == tabCompleters ? this : new Parser<A>(this.parser, tabCompleters, this.names, this.description, this.permission);
        }

        public Parser<A> withNames(List<String> names) {
            return this.names == names ? this : new Parser<A>(this.parser, this.tabCompleters, names, this.description, this.permission);
        }

        public Parser<A> withDescription(String description) {
            return this.description == description ? this : new Parser<A>(this.parser, this.tabCompleters, this.names, description, this.permission);
        }

        public Parser<A> withPermission(String permission) {
            return this.permission == permission ? this : new Parser<A>(this.parser, this.tabCompleters, this.names, this.description, permission);
        }
    }

    public static class Mapping<A>
    implements Command<A> {
        private final Map<String, Command<A>> commandMap;
        private final Command<A> fallback;

        private Mapping(Map<String, Command<A>> commandMap, @Nullable Command<A> fallback) {
            this.commandMap = commandMap;
            this.fallback = fallback;
        }

        @Override
        public <B> Mapping<B> map(Function<? super A, ? extends B> f) {
            HashMap<String, Command<A>> newMap = new HashMap<String, Command<A>>(this.commandMap.size());
            for (Map.Entry<String, Command<A>> pair : this.commandMap.entrySet()) {
                newMap.put(pair.getKey(), pair.getValue().map(f));
            }
            Command fallback = this.getFallback().orElse(null);
            return new Mapping<A>(newMap, fallback != null ? fallback.map(f) : null);
        }

        public Optional<Command<A>> getFallback() {
            return Optional.ofNullable(this.fallback);
        }

        public Map<String, Command<A>> getCommandMap() {
            return this.commandMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Command<A>> this$commandMap = this.getCommandMap();
            Map<String, Command<A>> other$commandMap = other.getCommandMap();
            if (this$commandMap == null ? other$commandMap != null : !((Object)this$commandMap).equals(other$commandMap)) {
                return false;
            }
            Optional<Command<A>> this$fallback = this.getFallback();
            Optional<Command<A>> other$fallback = other.getFallback();
            return !(this$fallback == null ? other$fallback != null : !((Object)this$fallback).equals(other$fallback));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Command<A>> $commandMap = this.getCommandMap();
            result = result * 59 + ($commandMap == null ? 43 : ((Object)$commandMap).hashCode());
            Optional<Command<A>> $fallback = this.getFallback();
            result = result * 59 + ($fallback == null ? 43 : ((Object)$fallback).hashCode());
            return result;
        }

        public String toString() {
            return "Command.Mapping(commandMap=" + this.getCommandMap() + ", fallback=" + this.getFallback() + ")";
        }

        public Mapping<A> withCommandMap(Map<String, Command<A>> commandMap) {
            return this.commandMap == commandMap ? this : new Mapping<A>(commandMap, this.fallback);
        }

        public Mapping<A> withFallback(Command<A> fallback) {
            return this.fallback == fallback ? this : new Mapping<A>(this.commandMap, fallback);
        }
    }
}

