/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.command.bukkit;

import io.typecraft.command.Argument;
import io.vavr.control.Try;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public final class BukkitArguments {
    public static final Argument<Player> playerArg = Argument.ofUnary("player", s -> Optional.ofNullable(Bukkit.getPlayer((String)s)), () -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
    public static final Argument<OfflinePlayer> offlinePlayerArg = Argument.ofUnary("offlineplayer", s -> Optional.of(Bukkit.getOfflinePlayer((String)s)), () -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
    public static final Argument<Material> materialArg = Argument.ofUnary("material", s -> Try.of(() -> Material.valueOf((String)s)).toJavaOptional(), () -> Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList()));
    public static final Argument<PotionEffectType> potionArg = Argument.ofUnary("potion", s -> Optional.ofNullable(PotionEffectType.getByName((String)s)), () -> Arrays.stream(PotionEffectType.values()).filter(Objects::nonNull).map(PotionEffectType::getName).collect(Collectors.toList()));
    public static final Argument<Enchantment> enchantArg = Argument.ofUnary("enchant", s -> Optional.ofNullable(Enchantment.getByName((String)s)), () -> Arrays.stream(Enchantment.values()).filter(Objects::nonNull).map(Enchantment::getName).collect(Collectors.toList()));

    private BukkitArguments() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

