/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.command.bukkit;

import io.typecraft.command.CommandHelp;
import io.typecraft.command.CommandSpec;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public final class BukkitCommandHelp {
    private final CommandSender sender;
    private final String label;
    private final List<String> arguments;
    private final CommandSpec spec;

    public CommandHelp toHelp() {
        return CommandHelp.of(this.getLabel(), this.getArguments(), this.getSpec());
    }

    public static String format(BukkitCommandHelp help) {
        CommandSpec spec = help.getSpec();
        String permission = spec.getPermission();
        if (permission.isEmpty() || help.getSender().hasPermission(permission)) {
            CommandSpec newSpec = spec.withArguments(spec.getArguments().stream().map(BukkitCommandHelp::translateToKor).collect(Collectors.toList()));
            return CommandHelp.format(help.toHelp().withSpec(newSpec));
        }
        return "";
    }

    public static String translateToKor(String argumentName) {
        switch (argumentName) {
            case "player": 
            case "offlineplayer": {
                return "\uc720\uc800";
            }
            case "material": {
                return "\uc544\uc774\ud15c";
            }
            case "potion": {
                return "\ud3ec\uc158";
            }
            case "enchant": {
                return "\uc778\ucc48\ud2b8";
            }
        }
        return argumentName;
    }

    private BukkitCommandHelp(CommandSender sender, String label, List<String> arguments, CommandSpec spec) {
        this.sender = sender;
        this.label = label;
        this.arguments = arguments;
        this.spec = spec;
    }

    public static BukkitCommandHelp of(CommandSender sender, String label, List<String> arguments, CommandSpec spec) {
        return new BukkitCommandHelp(sender, label, arguments, spec);
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public CommandSpec getSpec() {
        return this.spec;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitCommandHelp)) {
            return false;
        }
        BukkitCommandHelp other = (BukkitCommandHelp)o;
        CommandSender this$sender = this.getSender();
        CommandSender other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        List<String> this$arguments = this.getArguments();
        List<String> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        CommandSpec this$spec = this.getSpec();
        CommandSpec other$spec = other.getSpec();
        return !(this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommandSender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        List<String> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        return result;
    }

    public String toString() {
        return "BukkitCommandHelp(sender=" + this.getSender() + ", label=" + this.getLabel() + ", arguments=" + this.getArguments() + ", spec=" + this.getSpec() + ")";
    }

    public BukkitCommandHelp withSender(CommandSender sender) {
        return this.sender == sender ? this : new BukkitCommandHelp(sender, this.label, this.arguments, this.spec);
    }

    public BukkitCommandHelp withLabel(String label) {
        return this.label == label ? this : new BukkitCommandHelp(this.sender, label, this.arguments, this.spec);
    }

    public BukkitCommandHelp withArguments(List<String> arguments) {
        return this.arguments == arguments ? this : new BukkitCommandHelp(this.sender, this.label, arguments, this.spec);
    }

    public BukkitCommandHelp withSpec(CommandSpec spec) {
        return this.spec == spec ? this : new BukkitCommandHelp(this.sender, this.label, this.arguments, spec);
    }
}

