/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.command.bukkit;

import io.typecraft.command.Command;
import io.typecraft.command.CommandFailure;
import io.typecraft.command.CommandSpec;
import io.typecraft.command.CommandSuccess;
import io.typecraft.command.CommandTabResult;
import io.typecraft.command.bukkit.BukkitCommandConfig;
import io.typecraft.command.bukkit.BukkitCommandHelp;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitCommands {
    public static <A> void register(String commandName, Command<A> command, BiConsumer<CommandSender, A> executor, JavaPlugin plugin) {
        BukkitCommands.registerPrime(commandName, command, executor, (sender, a) -> Collections.emptyList(), BukkitCommandConfig.empty, plugin);
    }

    public static <A> void registerPrime(String commandName, Command<A> command, BiConsumer<CommandSender, A> executor, BiFunction<CommandSender, A, List<String>> tabCompleter, BukkitCommandConfig config, JavaPlugin plugin) {
        PluginTabExecutor<A> pluginTabExecutor = new PluginTabExecutor<A>(config, command, commandName, (Plugin)plugin, executor, tabCompleter);
        PluginCommand pluginCmd = plugin.getCommand(commandName);
        if (pluginCmd == null) {
            throw new IllegalArgumentException(String.format("Unknown command name: '%s'", commandName));
        }
        pluginCmd.setExecutor(pluginTabExecutor);
        pluginCmd.setTabCompleter(pluginTabExecutor);
    }

    public static <A> Optional<CommandSuccess<A>> execute(CommandSender sender, String label, String[] args, Command<A> command, BukkitCommandConfig config) {
        Either<CommandFailure<A>, CommandSuccess<A>> result = Command.parse(args, command);
        if (result.isRight()) {
            CommandSuccess<A> success = result.get();
            return Optional.of(success);
        }
        if (result.isLeft()) {
            CommandFailure<A> failure = result.getLeft();
            for (String line : BukkitCommands.getFailureMessage(sender, label, failure, config)) {
                sender.sendMessage(line);
            }
        }
        return Optional.empty();
    }

    public static <A> CommandTabResult<A> tabComplete(String[] args, Command<A> command) {
        return Command.tabComplete(args, command);
    }

    static <A> List<String> getCommandUsages(CommandSender sender, String label, String[] args, int position, Command<A> cmd, Function<BukkitCommandHelp, String> formatter) {
        String[] succArgs = args.length >= 1 ? Arrays.copyOfRange(args, 0, position) : new String[]{};
        return Command.getEntries(cmd).stream().flatMap(pair -> {
            CommandSpec spec;
            List<String> usageArgs = ((List)pair.getKey()).stream().flatMap(s -> Stream.concat(Arrays.stream(succArgs), Stream.of(s))).collect(Collectors.toList());
            String line = (String)formatter.apply(BukkitCommandHelp.of(sender, label, usageArgs, spec = Command.getSpec((Command)pair.getValue())));
            return line.isEmpty() ? Stream.empty() : Stream.of(line);
        }).collect(Collectors.toList());
    }

    private static <A> List<String> getFailureMessage(CommandSender sender, String label, CommandFailure<A> failure, BukkitCommandConfig config) {
        if (failure instanceof CommandFailure.FewArguments) {
            CommandFailure.FewArguments fewArgs = (CommandFailure.FewArguments)failure;
            return BukkitCommands.getCommandUsages(sender, label, fewArgs.getArguments(), fewArgs.getIndex(), fewArgs.getCommand(), config.getFormatter());
        }
        if (failure instanceof CommandFailure.UnknownSubCommand) {
            CommandFailure.UnknownSubCommand unknown = (CommandFailure.UnknownSubCommand)failure;
            String input = unknown.getArguments()[unknown.getIndex()];
            ArrayList<String> usages = new ArrayList<String>(BukkitCommands.getCommandUsages(sender, label, unknown.getArguments(), unknown.getIndex(), unknown.getCommand(), config.getFormatter()));
            usages.add(String.format("Command '%s' doesn't exists!", input));
            return usages;
        }
        return Collections.singletonList("Wrong command!");
    }

    private BukkitCommands() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class PluginTabExecutor<A>
    implements CommandExecutor,
    TabCompleter,
    PluginIdentifiableCommand {
        private final BukkitCommandConfig config;
        private final Command<A> command;
        private final String commandName;
        private final Plugin plugin;
        private final BiConsumer<CommandSender, A> executor;
        private final BiFunction<CommandSender, A, List<String>> tabCompleter;

        public PluginTabExecutor(BukkitCommandConfig config, Command<A> command, String commandName, Plugin plugin, BiConsumer<CommandSender, A> executor, BiFunction<CommandSender, A, List<String>> tabCompleter) {
            this.config = config;
            this.command = command;
            this.commandName = commandName;
            this.plugin = plugin;
            this.executor = executor;
            this.tabCompleter = tabCompleter;
        }

        public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String label, @NotNull String[] args) {
            BukkitCommands.execute(sender, label, args, this.command, this.config).ifPresent(succ -> this.executor.accept(sender, succ.getCommand()));
            return true;
        }

        @Nullable
        public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String alias, @NotNull String[] args) {
            CommandTabResult<A> result = BukkitCommands.tabComplete(args, this.command);
            if (result instanceof CommandTabResult.Suggestion) {
                return ((CommandTabResult.Suggestion)result).getSuggestions();
            }
            if (result instanceof CommandTabResult.Present) {
                Object value = ((CommandTabResult.Present)result).getCommand();
                return this.tabCompleter.apply(sender, value);
            }
            return Collections.emptyList();
        }

        @NotNull
        public Plugin getPlugin() {
            return this.plugin;
        }
    }
}

