/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.command.bukkit;

import io.typecraft.command.Converters;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public final class BukkitConverters {
    public static Object normalizeYamlObject(Object obj) {
        if (obj instanceof Collection) {
            return Converters.toCollectionAs(BukkitConverters::normalizeYamlObject, obj).orElse(Collections.emptyList());
        }
        if (obj instanceof Map) {
            return Converters.toMapAs(pair -> new Tuple2(pair._1, BukkitConverters.normalizeYamlObject(pair._2)), obj).orElse(Collections.emptyMap());
        }
        if (obj instanceof ConfigurationSection) {
            return BukkitConverters.normalizeYamlObject(((ConfigurationSection)obj).getValues(false));
        }
        return obj;
    }

    public static Map<String, Object> normalizeYamlMap(Map<String, Object> map) {
        return Converters.toMapAs(pair -> new Tuple2<String, Object>(pair._1.toString(), BukkitConverters.normalizeYamlObject(pair._2)), map).orElse(Collections.emptyMap());
    }

    private BukkitConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

