/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.command.bukkit;

import io.typecraft.command.Command;
import io.typecraft.command.bukkit.BukkitArguments;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;

public interface ExampleCommand {
    public static final Command<ExampleCommand> node = Command.mapping(Command.pair("potion", Command.argument(Potion::new, BukkitArguments.potionArg)), Command.pair("enchant", Command.argument(Enchant::new, BukkitArguments.enchantArg)));

    public static void execute(CommandSender sender, ExampleCommand x) {
        if (x instanceof Potion) {
            sender.sendMessage("\uc785\ub825\ud558\uc2e0 \ud3ec\uc158: " + ((Potion)x).getPotion().getName());
        } else if (x instanceof Enchant) {
            sender.sendMessage("\uc785\ub825\ud558\uc2e0 \uc778\ucc48\ud2b8: " + ((Enchant)x).getEnchantment().getName());
        }
    }

    public static class Enchant
    implements ExampleCommand {
        private final Enchantment enchantment;

        public Enchant(Enchantment enchantment) {
            this.enchantment = enchantment;
        }

        public Enchantment getEnchantment() {
            return this.enchantment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Enchant)) {
                return false;
            }
            Enchant other = (Enchant)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Enchantment this$enchantment = this.getEnchantment();
            Enchantment other$enchantment = other.getEnchantment();
            return !(this$enchantment == null ? other$enchantment != null : !this$enchantment.equals(other$enchantment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Enchant;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Enchantment $enchantment = this.getEnchantment();
            result = result * 59 + ($enchantment == null ? 43 : $enchantment.hashCode());
            return result;
        }

        public String toString() {
            return "ExampleCommand.Enchant(enchantment=" + this.getEnchantment() + ")";
        }
    }

    public static class Potion
    implements ExampleCommand {
        private final PotionEffectType potion;

        public Potion(PotionEffectType potion) {
            this.potion = potion;
        }

        public PotionEffectType getPotion() {
            return this.potion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Potion)) {
                return false;
            }
            Potion other = (Potion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PotionEffectType this$potion = this.getPotion();
            PotionEffectType other$potion = other.getPotion();
            return !(this$potion == null ? other$potion != null : !this$potion.equals(other$potion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Potion;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PotionEffectType $potion = this.getPotion();
            result = result * 59 + ($potion == null ? 43 : $potion.hashCode());
            return result;
        }

        public String toString() {
            return "ExampleCommand.Potion(potion=" + this.getPotion() + ")";
        }
    }
}

