/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.i18n.I18n;
import java.util.Set;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.WithTagValuesOrStereotypes;
import org.nuiton.eugene.models.extension.tagvalue.matcher.EqualsTagValueNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.provider.DefaultTagValueMetadatasProvider;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;

@AutoService(value={TagValueMetadatasProvider.class})
public class BeanTransformerTagValues
extends DefaultTagValueMetadatasProvider {
    public String getDescription() {
        return "EUGeNe Bean transformer tag values";
    }

    public BeanTransformerTagValues() {
        super((TagValueMetadata[])Store.values());
    }

    public String getSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.superClass, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public String getHelperSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.helperSuperClass, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public String getClassNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.classNamePrefix, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public String getClassNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue((TagValueMetadata)Store.classNameSuffix, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public boolean isGeneratePropertyChangeSupport(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.generatePropertyChangeSupport, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public boolean isGenerateNotEmptyCollections(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.generateNotEmptyCollections, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage, model});
    }

    public boolean isAddJavaBeanAnnotation(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.addJavaBeanAnnotation, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage});
    }

    public static enum Store implements TagValueMetadata
    {
        generatePropertyChangeSupport("Generate PropertyChangedSupport?", Boolean.TYPE, "true", ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        generateNotEmptyCollections("Generate none empty collections?", Boolean.TYPE, "true", ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        superClass("Bean super-class", String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        helperSuperClass("Helper super-class", String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        classNamePrefix("Class name's prefix", String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        classNameSuffix("Class name's suffix", String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),
        addJavaBeanAnnotation("Java 8 support", Boolean.TYPE, "true", ObjectModel.class, ObjectModelClassifier.class, ObjectModelPackage.class);

        private final Set<Class<?>> targets;
        private final Class<?> type;
        private final String i18nDescriptionKey;
        private final String defaultValue;

        private Store(String i18nDescriptionKey, Class<?> type, String defaultValue, Class<?> ... targets) {
            this.targets = ImmutableSet.copyOf((Object[])targets);
            this.type = type;
            this.i18nDescriptionKey = i18nDescriptionKey;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name();
        }

        public Set<Class<?>> getTargets() {
            return this.targets;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Class<EqualsTagValueNameMatcher> getMatcherClass() {
            return EqualsTagValueNameMatcher.class;
        }

        public String getDescription() {
            return I18n.t((String)this.i18nDescriptionKey, (Object[])new Object[0]);
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDeprecated() {
            return false;
        }
    }
}

