/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean;

import com.google.common.collect.Iterables;
import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.bean.definition.JavaBeanDefinition;
import io.ultreia.java4all.bean.definition.JavaBeanDefinitionStore;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Collection;

public abstract class AbstractJavaBean
implements JavaBean {
    private transient PropertyChangeSupport pcs;
    private transient VetoableChangeSupport vcs;
    private transient JavaBeanDefinition javaBeanDefinition;

    @Override
    public JavaBeanDefinition javaBeanDefinition() {
        return this.javaBeanDefinition == null ? (this.javaBeanDefinition = JavaBeanDefinitionStore.getDefinition(this.getJavaBeanType()).orElseThrow(() -> new NullPointerException("Can't find JavaBeanDefinition for " + this.getJavaBeanType()))) : this.javaBeanDefinition;
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs().addPropertyChangeListener(listener);
    }

    @Override
    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs().removePropertyChangeListener(listener);
    }

    @Override
    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs().removePropertyChangeListener(propertyName, listener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs().getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs().getPropertyChangeListeners(propertyName);
    }

    public final void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vcs().addVetoableChangeListener(listener);
    }

    public final void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vcs().removeVetoableChangeListener(listener);
    }

    public final VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vcs().getVetoableChangeListeners();
    }

    public final void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vcs().addVetoableChangeListener(propertyName, listener);
    }

    public final void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vcs().removeVetoableChangeListener(propertyName, listener);
    }

    public final VetoableChangeListener[] getVetoableChangeListeners(String propertyName) {
        return this.vcs().getVetoableChangeListeners(propertyName);
    }

    protected Class getJavaBeanType() {
        return this.getClass();
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs().firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, Object newValue) {
        this.pcs().firePropertyChange(propertyName, null, newValue);
    }

    protected final void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs().firePropertyChange(evt);
    }

    protected final PropertyChangeSupport pcs() {
        return this.pcs == null ? (this.pcs = new PropertyChangeSupport(this)) : this.pcs;
    }

    protected final VetoableChangeSupport vcs() {
        return this.vcs == null ? (this.vcs = new VetoableChangeSupport(this)) : this.vcs;
    }

    protected final void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.pcs().fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    protected final boolean hasPropertyChangeListeners(String propertyName) {
        return this.pcs().hasListeners(propertyName);
    }

    protected final boolean hasVetoableChangeListeners(String propertyName) {
        return this.vcs().hasListeners(propertyName);
    }

    protected final void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vcs().fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected final void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.vcs().fireVetoableChange(evt);
    }

    protected final <B> B getChild(Collection<B> child, int index) {
        return (B)Iterables.get(child, (int)index);
    }
}

