/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.util.Predicates;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public interface JavaBeanPredicate<O extends JavaBean, P extends JavaBeanPredicate<O, P>>
extends Predicate<O> {
    public void addPredicate(Predicate<O> var1);

    public Predicate<O> predicate();

    public static class StringQuery<O extends JavaBean, P extends JavaBeanPredicate<O, P>, Q extends StringQuery<O, P, Q>>
    extends SimpleComparableQuery<O, String, P, Q> {
        public StringQuery(P parent, Function<O, String> getter) {
            super(parent, getter);
        }

        public final P contains(String propertyValue) {
            return this.addPredicate(Predicates.StringContains((String)propertyValue));
        }

        public final P notContains(String propertyValue) {
            return this.addPredicate(Predicates.NotStringContains((String)propertyValue));
        }

        public final P matches(String propertyValue) {
            return this.addPredicate(Predicates.StringMatches((String)propertyValue));
        }

        public final P notMatches(String propertyValue) {
            return this.addPredicate(Predicates.NotStringMatches((String)propertyValue));
        }

        public final Q containsAnd(String propertyValue) {
            this.addPredicate(Predicates.StringContains((String)propertyValue));
            return (Q)((StringQuery)this.q());
        }

        public final Q notContainsAnd(String propertyValue) {
            this.addPredicate(Predicates.NotStringContains((String)propertyValue));
            return (Q)((StringQuery)this.q());
        }

        public final Q matchesAnd(String propertyValue) {
            this.addPredicate(Predicates.StringMatches((String)propertyValue));
            return (Q)((StringQuery)this.q());
        }

        public final Q notMatchesAnd(String propertyValue) {
            this.addPredicate(Predicates.NotStringMatches((String)propertyValue));
            return (Q)((StringQuery)this.q());
        }
    }

    public static class SimpleComparableQuery<O extends JavaBean, V extends Comparable<V>, P extends JavaBeanPredicate<O, P>, Q extends SimpleComparableQuery<O, V, P, Q>>
    extends ObjectQuery<O, V, P, Q>
    implements ComparableQuery<O, V, P, Q> {
        public SimpleComparableQuery(P parent, Function<O, V> getter) {
            super(parent, getter);
        }
    }

    public static class ObjectBooleanQuery<O extends JavaBean, P extends JavaBeanPredicate<O, P>, Q extends ObjectBooleanQuery<O, P, Q>>
    extends SimpleComparableQuery<O, Boolean, P, Q>
    implements BooleanQuery<O, P, Q> {
        public ObjectBooleanQuery(P parent, Function<O, Boolean> getter) {
            super(parent, getter);
        }
    }

    public static class PrimitiveBooleanQuery<O extends JavaBean, P extends JavaBeanPredicate<O, P>, Q extends PrimitiveBooleanQuery<O, P, Q>>
    extends PrimitiveObjectQuery<O, Boolean, P, Q>
    implements BooleanQuery<O, P, Q> {
        public PrimitiveBooleanQuery(P parent, Function<O, Boolean> getter) {
            super(parent, getter);
        }
    }

    public static class PrimitiveObjectQuery<O extends JavaBean, V extends Comparable<V>, P extends JavaBeanPredicate<O, P>, Q extends PrimitiveObjectQuery<O, V, P, Q>>
    extends QuerySupport<O, V, P, Q>
    implements ComparableQuery<O, V, P, Q> {
        public PrimitiveObjectQuery(P parent, Function<O, V> getter) {
            super(parent, getter);
        }
    }

    public static class ObjectQuery<O extends JavaBean, V, P extends JavaBeanPredicate<O, P>, Q extends ObjectQuery<O, V, P, Q>>
    extends QuerySupport<O, V, P, Q> {
        public ObjectQuery(P parent, Function<O, V> getter) {
            super(parent, getter);
        }

        public final P isNull() {
            Object parent = this.parent();
            parent.addPredicate((O d) -> {
                Object v = this.getter(d);
                return v == null;
            });
            return parent;
        }

        public final P isNotNull() {
            Object parent = this.parent();
            parent.addPredicate((O d) -> {
                Object v = this.getter(d);
                return v != null;
            });
            return parent;
        }

        public final Q isNullAnd() {
            this.isNull();
            return (Q)((ObjectQuery)this.q());
        }

        public final Q isNotNullAnd() {
            this.isNotNull();
            return (Q)((ObjectQuery)this.q());
        }
    }

    public static abstract class QuerySupport<O extends JavaBean, V, P extends JavaBeanPredicate<O, P>, Q extends QuerySupport<O, V, P, Q>>
    implements Query<O, V, P, Q> {
        private final P parent;
        private final Function<O, V> getter;

        protected QuerySupport(P parent, Function<O, V> getter) {
            this.parent = parent;
            this.getter = getter;
        }

        @Override
        public final P parent() {
            return this.parent;
        }

        @Override
        public final V getter(O element) {
            return element == null ? null : (V)this.getter.apply(element);
        }

        @Override
        public final Q q() {
            return (Q)this;
        }
    }

    public static interface ComparableQuery<O extends JavaBean, V extends Comparable<V>, P extends JavaBeanPredicate<O, P>, Q extends ComparableQuery<O, V, P, Q>>
    extends Query<O, V, P, Q> {
        default public P isBefore(V propertyValue) {
            return this.addPredicate(Predicates.Before(propertyValue));
        }

        default public P isBeforeOrEquals(V propertyValue) {
            return this.addPredicate(Predicates.BeforeOrEquals(propertyValue));
        }

        default public P isAfter(V propertyValue) {
            return this.addPredicate(Predicates.AfterOrEquals(propertyValue));
        }

        default public P isAfterOrEquals(V propertyValue) {
            return this.addPredicate(Predicates.AfterOrEquals(propertyValue));
        }

        default public P isBetween(V min, V max) {
            return this.addPredicate(Predicates.Between(min, max));
        }

        default public P isBetweenOrEquals(V min, V max) {
            return this.addPredicate(Predicates.BetweenOrEquals(min, max));
        }

        default public Q isBeforeAnd(V propertyValue) {
            this.isBefore(propertyValue);
            return (Q)((ComparableQuery)this.q());
        }

        default public Q isBeforeOrEqualsAnd(V propertyValue) {
            this.isBeforeOrEquals(propertyValue);
            return (Q)((ComparableQuery)this.q());
        }

        default public Q isAfterAnd(V propertyValue) {
            this.isAfter(propertyValue);
            return (Q)((ComparableQuery)this.q());
        }

        default public Q isAfterOrEqualsAnd(V propertyValue) {
            this.isAfterOrEquals(propertyValue);
            return (Q)((ComparableQuery)this.q());
        }

        default public Q isBetweenAnd(V min, V max) {
            this.isBetweenAnd(min, max);
            return (Q)((ComparableQuery)this.q());
        }

        default public Q isBetweenOrEqualsAnd(V min, V max) {
            this.isBetweenOrEqualsAnd(min, max);
            return (Q)((ComparableQuery)this.q());
        }
    }

    public static interface BooleanQuery<O extends JavaBean, P extends JavaBeanPredicate<O, P>, Q extends ComparableQuery<O, Boolean, P, Q>>
    extends ComparableQuery<O, Boolean, P, Q> {
        default public P isTrue() {
            return this.isEquals(true);
        }

        default public P isFalse() {
            return this.isEquals(false);
        }

        default public Q isTrueAnd() {
            this.isTrue();
            return (Q)((ComparableQuery)this.q());
        }

        default public Q isFalseAnd() {
            this.isFalse();
            return (Q)((ComparableQuery)this.q());
        }
    }

    public static interface Query<O extends JavaBean, V, P extends JavaBeanPredicate<O, P>, Q extends Query<O, V, P, Q>> {
        public P parent();

        public V getter(O var1);

        default public P isEquals(V propertyValue) {
            return this.addPredicate(Predicates.Equals(propertyValue));
        }

        default public P isNotEquals(V propertyValue) {
            return this.addPredicate(Predicates.NotEquals(propertyValue));
        }

        default public P isIn(Collection<V> propertyValue) {
            return this.addPredicate(Predicates.In(propertyValue));
        }

        default public P isNotIn(Collection<V> propertyValue) {
            return this.addPredicate(Predicates.NotIn(propertyValue));
        }

        default public Q isEqualsAnd(V propertyValue) {
            this.isEquals(propertyValue);
            return this.q();
        }

        default public Q isInAnd(Collection<V> propertyValue) {
            this.addPredicate(Predicates.In(propertyValue));
            return this.q();
        }

        default public Q isNotInAnd(Collection<V> propertyValue) {
            this.addPredicate(Predicates.NotIn(propertyValue));
            return this.q();
        }

        default public Q isNotEqualsAnd(V propertyValue) {
            this.isNotEquals(propertyValue);
            return this.q();
        }

        default public P addPredicate(Predicate<V> predicate) {
            Objects.requireNonNull(predicate);
            P parent = this.parent();
            parent.addPredicate((O d) -> {
                V v = this.getter(d);
                return v != null && predicate.test(v);
            });
            return parent;
        }

        public Q q();
    }
}

