/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean.definition;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.bean.definition.JavaBeanDefinition;
import io.ultreia.java4all.bean.definition.JavaBeanPropertyDefinition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractJavaBeanDefinition
implements JavaBeanDefinition {
    private ImmutableSet<Class<?>> acceptedTypes;
    private ImmutableMap<String, JavaBeanPropertyDefinition<?, ?>> properties;
    private Class<?> mainType;

    public final ImmutableSet<Class<?>> types() {
        return this.acceptedTypes == null ? (this.acceptedTypes = Objects.requireNonNull(this.loadAcceptedTypes())) : this.acceptedTypes;
    }

    protected abstract ImmutableSet<Class<?>> loadAcceptedTypes();

    protected abstract ImmutableMap<String, Class<?>> loadTypes();

    protected abstract ImmutableMap<String, Function<?, ?>> loadGetters();

    protected abstract ImmutableMap<String, BiConsumer<?, ?>> loadSetters();

    public final ImmutableMap<String, JavaBeanPropertyDefinition<?, ?>> properties() {
        if (this.properties == null) {
            ImmutableMap<String, Function<?, ?>> getters = Objects.requireNonNull(this.loadGetters());
            ImmutableMap<String, BiConsumer<?, ?>> setters = Objects.requireNonNull(this.loadSetters());
            ImmutableMap<String, Class<?>> types = Objects.requireNonNull(this.loadTypes());
            List allPropertyNames = Stream.concat(getters.keySet().stream(), setters.keySet().stream()).distinct().sorted(String::compareTo).collect(Collectors.toList());
            ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
            for (String propertyName : allPropertyNames) {
                Class type = (Class)types.get((Object)propertyName);
                Function getter = (Function)getters.get((Object)propertyName);
                BiConsumer setter = (BiConsumer)setters.get((Object)propertyName);
                propertiesBuilder.put((Object)propertyName, new JavaBeanPropertyDefinition(propertyName, type, getter, setter));
            }
            this.properties = propertiesBuilder.build();
        }
        return this.properties;
    }

    @Override
    public final <O extends JavaBean> O newInstance() {
        try {
            return (O)((JavaBean)this.mainType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Can't instantiate with: " + this.mainType, e.getCause());
        }
    }

    private Class<?> mainType() {
        if (this.mainType == null) {
            for (Class acceptedType : this.acceptedTypes) {
                if (acceptedType.isInterface() || Modifier.isAbstract(acceptedType.getModifiers())) continue;
                this.mainType = acceptedType;
            }
            Objects.requireNonNull(this.mainType, "Can't find a type to instantiate in: " + this.acceptedTypes);
        }
        return this.mainType;
    }
}

