/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean.definition;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.bean.definition.JavaBeanDefinition;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;

public final class JavaBeanDefinitionStore {
    private static Map<Class, JavaBeanDefinition> DEFINITIONS;

    private JavaBeanDefinitionStore() {
    }

    public static Optional<JavaBeanDefinition> getDefinition(Class type) {
        return Optional.ofNullable(JavaBeanDefinitionStore.definitions().get(Objects.requireNonNull(type)));
    }

    public static Optional<JavaBeanDefinition> getDefinition(JavaBean javaBean) {
        return Optional.ofNullable(JavaBeanDefinitionStore.definitions().get(Objects.requireNonNull(javaBean).getClass()));
    }

    public static Map<Class, JavaBeanDefinition> definitions() {
        return DEFINITIONS == null ? (DEFINITIONS = JavaBeanDefinitionStore.loadDefinitions()) : DEFINITIONS;
    }

    public static <J extends JavaBeanDefinition> J definition(Class<J> javaBeanDefinitionType) {
        return (J)JavaBeanDefinitionStore.definitions().values().stream().filter(d -> javaBeanDefinitionType.equals(d.getClass())).findFirst().orElseThrow(IllegalStateException::new);
    }

    private static synchronized Map<Class, JavaBeanDefinition> loadDefinitions() {
        LinkedHashMap<Class, JavaBeanDefinition> result = new LinkedHashMap<Class, JavaBeanDefinition>();
        for (JavaBeanDefinition javaBeanDefinition : ServiceLoader.load(JavaBeanDefinition.class)) {
            for (Class<?> o : javaBeanDefinition.types()) {
                result.put(o, javaBeanDefinition);
            }
        }
        return result;
    }
}

