/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean.definition;

import com.google.common.base.Defaults;
import io.ultreia.java4all.bean.JavaBean;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class JavaBeanPropertyDefinition<O extends JavaBean, V> {
    private final String propertyName;
    private final Class<V> type;
    private final Function<O, V> getter;
    private final BiConsumer<O, V> setter;
    private final V defaultValue;

    JavaBeanPropertyDefinition(String propertyName, Class<V> type, Function<O, V> getter, BiConsumer<O, V> setter) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.type = Objects.requireNonNull(type);
        this.getter = getter;
        this.setter = setter;
        this.defaultValue = type.isPrimitive() ? Defaults.defaultValue(type) : null;
    }

    public JavaBeanPropertyDefinition<O, V> checkCanRead() {
        if (!this.canRead()) {
            throw new IllegalArgumentException("Property " + this.propertyName + " is not readable.");
        }
        return this;
    }

    public JavaBeanPropertyDefinition<O, V> checkCanWrite() {
        if (!this.canWrite()) {
            throw new IllegalArgumentException("Property " + this.propertyName + " is not writable.");
        }
        return this;
    }

    public String propertyName() {
        return this.propertyName;
    }

    public Class<?> type() {
        return this.type;
    }

    public Function<O, V> getter() {
        return this.getter;
    }

    public BiConsumer<O, V> setter() {
        return this.setter;
    }

    public V defaultValue() {
        return this.defaultValue;
    }

    public boolean canRead() {
        return this.getter != null;
    }

    public boolean canWrite() {
        return this.setter != null;
    }

    public boolean canReadAndWrite() {
        return this.canRead() && this.canWrite();
    }

    public V get(O javaBean) {
        return this.getter.apply(javaBean);
    }

    public void set(O javaBean, V value) {
        this.setter.accept(javaBean, value);
    }

    public void copy(O source, O target) {
        V value = this.get(source);
        this.set(target, value);
    }

    public void clear(O javaBean) {
        this.set(javaBean, this.defaultValue);
    }
}

