/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean.spi;

import com.google.auto.service.AutoService;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.bean.AbstractJavaBeanComparatorBuilder;
import io.ultreia.java4all.bean.AbstractJavaBeanInstanceBuilder;
import io.ultreia.java4all.bean.AbstractJavaBeanPredicate;
import io.ultreia.java4all.bean.AbstractJavaBeanStream;
import io.ultreia.java4all.bean.definition.AbstractJavaBeanDefinition;
import io.ultreia.java4all.bean.definition.JavaBeanDefinition;
import io.ultreia.java4all.bean.spi.GenerateJavaBeanDefinition;
import io.ultreia.java4all.util.ImportManager;
import java.beans.Introspector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractElementVisitor8;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.ultreia.java4all.bean.spi.GenerateJavaBeanDefinition"})
@SupportedOptions(value={"debug"})
public class GenerateJavaBeanDefinitionProcessor
extends AbstractProcessor {
    private static final String DEFINITION_JAVA_FILE = "package %s;\n\n%s\n@AutoService(JavaBeanDefinition.class)\n@Generated(value = \"%s\", date = \"%s\")\npublic final class %sJavaBeanDefinition%s extends AbstractJavaBeanDefinition {\n\n    @Override\n    protected final ImmutableSet<Class<?>> loadAcceptedTypes() {\n        return ImmutableSet.<Class<?>>builder()\n%s                .build();\n    }\n\n    @Override\n    protected final ImmutableMap<String, Class<?>> loadTypes() {\n        return ImmutableMap.<String, Class<?>>builder()\n%s                .build();\n    }\n\n    @SuppressWarnings(\"unchecked\")\n    @Override\n    protected final ImmutableMap<String, Function<?, ?>> loadGetters() {\n        return (ImmutableMap) ImmutableMap.<String, Function<%s, ?>>builder()\n%s                .build();\n    }\n\n    @SuppressWarnings(\"unchecked\")\n    @Override\n    protected final ImmutableMap<String, BiConsumer<?, ?>> loadSetters() {\n        return (ImmutableMap) ImmutableMap.<String, BiConsumer<%s, ?>>builder()\n%s                .build();\n    }\n%s%s%s\n}\n";
    private static final String PREDICATE_JAVA_FILE = "\n    public static final class %s%s extends AbstractJavaBeanPredicate<%s%s, %s%s> {\n\n        protected %s() {\n            super(%sJavaBeanDefinition.class);\n        }\n\n        protected %s(%s javaBeanDefinition) {\n            super(javaBeanDefinition);\n        }\n%s\n    }\n";
    private static final String STREAM_JAVA_FILE = "\n    public static final class %s%s extends AbstractJavaBeanStream<%s%s, %s%s> {\n\n        protected %s(Collection<%s%s> elements) {\n            super(%sJavaBeanDefinition.class, elements);\n        }\n\n        protected %s(%sJavaBeanDefinition javaBeanDefinition, Collection<%s%s> elements) {\n            super(javaBeanDefinition, elements);\n        }\n%s\n    }\n";
    private static final String COMPARATOR_JAVA_FILE = "\n    public static final class %s%s extends AbstractJavaBeanComparatorBuilder<%s%s, %s%s> {\n\n        protected %s() {\n            super(%sJavaBeanDefinition.class);\n        }\n\n        protected %s(%s javaBeanDefinition) {\n            super(javaBeanDefinition);\n        }\n%s\n    }\n";
    private static final String INSTANCE_JAVA_FILE = "\n    public static final class %s%s extends AbstractJavaBeanInstanceBuilder<%s%s, %s%s> {\n\n        protected %s() {\n            super(%sJavaBeanDefinition.class);\n        }\n\n        protected %s(%s javaBeanDefinition) {\n            super(javaBeanDefinition);\n        }\n%s\n    }\n";
    private static final List<String> EXCLUDED_PROPERTIES = Arrays.asList("ters", "class", "propertyChangeListeners", "vetoableChangeListeners");
    private Set<String> done = new TreeSet<String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                String classNameWithRaw;
                String classNameWithFormal;
                String generatedClassName;
                String packageName;
                TypeElement classElement = (TypeElement)element;
                String fullyQualifiedName = classElement.getQualifiedName().toString();
                String fullClassName = fullyQualifiedName.substring((packageName = this.processingEnv.getElementUtils().getPackageOf(classElement).toString()).length() + 1);
                String className = fullClassName;
                int i = className.indexOf(".");
                if (i > -1) {
                    className = className.substring(i + 1);
                }
                if (!this.done.add(generatedClassName = packageName + "." + className + "JavaBeanDefinition")) {
                    this.logWarning(String.format("Skip already processed class: %s", generatedClassName));
                    continue;
                }
                this.logDebug(String.format("Detect JavaBean: %s", classElement));
                Map<String, String> formalMap = this.computeFormalParameters(classElement);
                List<? extends TypeParameterElement> typeParameters = classElement.getTypeParameters();
                TreeSet<String> excludeProperties = new TreeSet<String>(EXCLUDED_PROPERTIES);
                Map<String, ExecutableElement> getters = classElement.accept(new GettersDetector(this.processingEnv, excludeProperties), null);
                Map<String, ExecutableElement> setters = classElement.accept(new SettersDetector(this.processingEnv, excludeProperties), null);
                LinkedList<String> formal = new LinkedList<String>();
                if (typeParameters.isEmpty()) {
                    classNameWithFormal = "";
                    classNameWithRaw = "";
                } else {
                    LinkedList<String> raw = new LinkedList<String>();
                    for (TypeParameterElement typeParameterElement : typeParameters) {
                        String simpleName = typeParameterElement.getSimpleName().toString();
                        String type = typeParameterElement.getBounds().get(0).toString();
                        formal.add(simpleName);
                        raw.add(simpleName + " extends " + type);
                    }
                    classNameWithFormal = String.format("<%s>", Joiner.on((String)", ").join(formal));
                    classNameWithRaw = String.format("<%s>", Joiner.on((String)", ").join(raw));
                }
                GenerateJavaBeanDefinition realAnnotation = classElement.getAnnotation(GenerateJavaBeanDefinition.class);
                try {
                    this.generateDefinitionFile(realAnnotation, packageName, generatedClassName, fullClassName, className, classNameWithFormal, classNameWithRaw, getters, setters, formal, formalMap);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't generate JavaBean definition file for: " + classElement, e);
                }
            }
        }
        return true;
    }

    private void generateDefinitionFile(GenerateJavaBeanDefinition realAnnotation, String packageName, String generatedClassName, String fullClassName, String className, String classNameWithFormal, String classNameWithRaw, Map<String, ExecutableElement> getters, Map<String, ExecutableElement> setters, List<String> formal, Map<String, String> formalMap) throws IOException {
        boolean empty;
        String[] classes = realAnnotation.types();
        boolean predicate = realAnnotation.predicate();
        boolean comparator = realAnnotation.comparator();
        boolean stream = realAnnotation.stream();
        boolean instance = realAnnotation.instance();
        StringBuilder acceptedTypesBuilder = new StringBuilder();
        if (classes.length == 0) {
            acceptedTypesBuilder.append(String.format("                .add(%s.class)\n", fullClassName));
        } else {
            for (String aClass : classes) {
                acceptedTypesBuilder.append(String.format("                .add(%s.class)\n", aClass));
            }
        }
        String acceptedTypesField = acceptedTypesBuilder.toString();
        StringBuilder typesBuilder = new StringBuilder();
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        StringBuilder gettersBuilder = new StringBuilder();
        for (Map.Entry<String, ExecutableElement> entry : getters.entrySet()) {
            String string = entry.getKey();
            ExecutableElement methodElement = entry.getValue();
            String methodName = methodElement.getSimpleName().toString();
            String methodType = this.processingEnv.getTypeUtils().erasure(methodElement.getReturnType()).toString();
            gettersBuilder.append(String.format("                .put(\"%s\", %s::%s)\n", string, fullClassName, methodName));
            if (!properties.add(string)) continue;
            typesBuilder.append(String.format("                .put(\"%s\", %s.class)\n", string, methodType));
        }
        StringBuilder settersBuilder = new StringBuilder();
        for (Map.Entry<String, ExecutableElement> entry : setters.entrySet()) {
            String propertyName = entry.getKey();
            ExecutableElement methodElement = entry.getValue();
            String methodName = methodElement.getSimpleName().toString();
            Element variableElement = methodElement.getParameters().get(0);
            String methodType = this.computeSetterMethodParameterType(className, formal, formalMap, methodElement, variableElement);
            settersBuilder.append(String.format("                .put(\"%s\", (e, v) -> e.%s((%s) v))\n", propertyName, methodName, methodType));
            if (!properties.add(propertyName)) continue;
            typesBuilder.append(String.format("                .put(\"%s\", %s.class)\n", propertyName, methodType));
        }
        String string = typesBuilder.toString();
        ImportManager importManager = new ImportManager(packageName);
        importManager.addImport(AutoService.class);
        importManager.addImport(Generated.class);
        importManager.addImport(JavaBeanDefinition.class);
        importManager.addImport(AbstractJavaBeanDefinition.class);
        importManager.addImport(Function.class);
        importManager.addImport(ImmutableSet.class);
        importManager.addImport(BiConsumer.class);
        importManager.addImport(ImmutableMap.class);
        importManager.addImport(ImmutableSet.class);
        if (!className.equals(fullClassName)) {
            importManager.addImport(packageName + "." + fullClassName);
        }
        String addFormal = (empty = classNameWithFormal.isEmpty()) ? "" : "<>";
        StringBuilder extraStaticsMethods = new StringBuilder();
        StringBuilder extraMethods = new StringBuilder();
        StringBuilder extraClasses = new StringBuilder();
        if (predicate) {
            importManager.addImport(AbstractJavaBeanPredicate.class);
            extraClasses.append(this.generatePredicateBuilderFile(className + "Predicate", className, classNameWithFormal, classNameWithRaw, getters));
            extraMethods.append(String.format("\n    @Override\n    public %sPredicate predicateBuilder() {\n        return new %sPredicate(this);\n    }\n", className, className));
            extraStaticsMethods.append(String.format("\n    public static %s%sPredicate%s predicate() {\n        return new %sPredicate%s();\n    }\n", empty ? "" : classNameWithRaw + " ", className, classNameWithFormal, className, addFormal));
        }
        if (stream) {
            importManager.addImport(AbstractJavaBeanStream.class);
            importManager.addImport(Collection.class);
            extraClasses.append(this.generateStreamFile(className + "Stream", className, classNameWithFormal, classNameWithRaw, getters));
            extraStaticsMethods.append(String.format("\n    public static %s%sStream%s stream(Collection<%s%s> elements) {\n        return new %sStream%s(elements);\n    }\n", empty ? "" : classNameWithRaw + " ", className, classNameWithFormal, className, classNameWithFormal, className, addFormal));
        }
        if (comparator) {
            importManager.addImport(AbstractJavaBeanComparatorBuilder.class);
            extraClasses.append(this.generateComparatorBuilderFile(className + "ComparatorBuilder", className, classNameWithFormal, classNameWithRaw, getters));
            extraMethods.append(String.format("\n    @Override\n    public %sComparatorBuilder comparatorBuilder() {\n        return new %sComparatorBuilder(this);\n    }\n", className, className));
            extraStaticsMethods.append(String.format("\n    public static %s%sComparatorBuilder%s comparator() {\n        return new %sComparatorBuilder%s();\n    }\n", empty ? "" : classNameWithRaw + " ", className, classNameWithFormal, className, addFormal));
        }
        if (instance) {
            importManager.addImport(AbstractJavaBeanInstanceBuilder.class);
            extraClasses.append(this.generateInstanceBuilderFile(className + "InstanceBuilder", className, classNameWithFormal, classNameWithRaw, setters));
            extraMethods.append(String.format("\n    @Override\n    public %sInstanceBuilder instanceBuilder() {\n        return new %sInstanceBuilder(this);\n    }\n", className, className));
            extraStaticsMethods.append(String.format("\n    public static %s%sInstanceBuilder%s instance() {\n        return new %sInstanceBuilder%s();\n    }\n", empty ? "" : classNameWithRaw + " ", className, classNameWithFormal, className, addFormal));
        }
        String imports = importManager.getImportsSection("\n");
        String content = String.format(DEFINITION_JAVA_FILE, packageName, imports, this.getClass().getName(), new Date(), className, classNameWithRaw, acceptedTypesField, string, fullClassName + classNameWithFormal, gettersBuilder.toString(), fullClassName + classNameWithFormal, settersBuilder.toString(), extraStaticsMethods.toString(), extraMethods.toString(), extraClasses.toString());
        this.generate(generatedClassName, content);
    }

    private Map<String, String> computeFormalParameters(TypeElement classElement) {
        TypeElement superclassElement;
        TreeMap<String, String> formalMap = new TreeMap<String, String>();
        TypeMirror superclass = classElement.getSuperclass();
        while (superclass != null && (superclassElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superclass)) != null) {
            List<? extends TypeParameterElement> superClassTypeParameters = superclassElement.getTypeParameters();
            for (TypeParameterElement typeParameterElement : superClassTypeParameters) {
                String simpleName = typeParameterElement.getSimpleName().toString();
                if (formalMap.containsKey(simpleName)) continue;
                TypeMirror typeMirror = this.processingEnv.getTypeUtils().asMemberOf((DeclaredType)classElement.asType(), typeParameterElement);
                formalMap.put(simpleName, typeMirror.toString());
                this.logDebug(String.format("Add formal parameter: %s \u2192 %s", simpleName, typeMirror));
            }
            superclass = superclassElement.getSuperclass();
        }
        return formalMap;
    }

    private String computeSetterMethodParameterType(String className, List<String> formal, Map<String, String> formalMap, ExecutableElement methodElement, Element variableElement) {
        if (!methodElement.getTypeParameters().isEmpty() && variableElement.asType().getKind() == TypeKind.TYPEVAR && !formal.contains(variableElement.asType().toString())) {
            return this.processingEnv.getTypeUtils().erasure(variableElement.asType()).toString();
        }
        String methodType = variableElement.asType().toString();
        if (!methodType.contains("<")) {
            return methodType;
        }
        if (methodType.matches(".+<\\s*\\?\\s*>\\s*$")) {
            return methodType;
        }
        DeclaredType capture = (DeclaredType)this.processingEnv.getTypeUtils().capture(variableElement.asType());
        LinkedList<String> formalValues = new LinkedList<String>();
        boolean use = false;
        for (TypeMirror typeMirror : capture.getTypeArguments()) {
            String simpleName = typeMirror.toString();
            String rawValue = formalMap.get(simpleName);
            if (rawValue != null) {
                formalValues.add(rawValue);
                use = true;
                continue;
            }
            formalValues.add(typeMirror.toString());
            use = true;
        }
        if (use) {
            methodType = String.format("%s< %s >", this.processingEnv.getTypeUtils().erasure(variableElement.asType()).toString(), String.join((CharSequence)", ", formalValues));
        }
        this.logDebug(String.format("Class %s - Method Parameterized type: %s", className, methodType));
        return methodType;
    }

    /*
     * WARNING - void declaration
     */
    private String generatePredicateBuilderFile(String predicateSimpleClassName, String className, String classNameWithFormal, String classNameWithRaw, Map<String, ExecutableElement> getters) {
        LinkedList<String> methods = new LinkedList<String>();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror t2 = typeUtils.erasure(this.processingEnv.getElementUtils().getTypeElement(Comparable.class.getName()).asType());
        for (Map.Entry<String, ExecutableElement> entry : getters.entrySet()) {
            void var15_15;
            ExecutableElement value = entry.getValue();
            TypeMirror returnType = value.getReturnType();
            boolean comparable = false;
            for (TypeMirror typeMirror : typeUtils.directSupertypes(returnType)) {
                TypeMirror erasure = typeUtils.erasure(typeMirror);
                if (!t2.equals(erasure)) continue;
                comparable = true;
                break;
            }
            String propertyName = entry.getKey();
            boolean primitiveType = returnType instanceof PrimitiveType;
            if (primitiveType) {
                String string = typeUtils.boxedClass((PrimitiveType)returnType).toString();
                comparable = true;
            } else {
                String string = typeUtils.erasure(returnType).toString();
            }
            boolean booleanType = returnType.toString().toLowerCase().endsWith("boolean");
            String methodName = value.getSimpleName().toString();
            methodName = methodName.startsWith("is") ? "where" + methodName.substring(2) : "where" + methodName.substring(3);
            if (booleanType) {
                methods.add(String.format("\n        public %s<%s, %s, ?> %s() {\n            return %s(\"%s\");\n        }", primitiveType ? "PrimitiveBooleanQuery" : "ObjectBooleanQuery", className + classNameWithFormal, predicateSimpleClassName + classNameWithFormal, methodName, primitiveType ? "wherePrimitiveBoolean" : "whereBoolean", propertyName));
                continue;
            }
            if (comparable) {
                if (var15_15.contains(".String")) {
                    methods.add(String.format("\n        public StringQuery<%s, %s, ?> %s() {\n            return whereString(\"%s\");\n        }", className + classNameWithFormal, predicateSimpleClassName + classNameWithFormal, methodName, propertyName));
                    continue;
                }
                methods.add(String.format("\n        public %s<%s, %s, %s, ?> %s() {\n            return %s(\"%s\");\n        }", primitiveType ? "PrimitiveObjectQuery" : "ComparableQuery", className + classNameWithFormal, var15_15, predicateSimpleClassName + classNameWithFormal, methodName, primitiveType ? "wherePrimitive" : "whereComparable", propertyName));
                continue;
            }
            methods.add(String.format("\n        public ObjectQuery<%s, %s, %s, ?> %s() {\n            return where(\"%s\");\n        }", className + classNameWithFormal, var15_15, predicateSimpleClassName + classNameWithFormal, methodName, propertyName));
        }
        return String.format(PREDICATE_JAVA_FILE, predicateSimpleClassName, classNameWithRaw, className, classNameWithFormal, predicateSimpleClassName, classNameWithFormal, predicateSimpleClassName, className, predicateSimpleClassName, className + "JavaBeanDefinition", String.join((CharSequence)"\n", methods));
    }

    /*
     * WARNING - void declaration
     */
    private String generateStreamFile(String predicateSimpleClassName, String className, String classNameWithFormal, String classNameWithRaw, Map<String, ExecutableElement> getters) {
        LinkedList<String> methods = new LinkedList<String>();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror t2 = typeUtils.erasure(this.processingEnv.getElementUtils().getTypeElement(Comparable.class.getName()).asType());
        for (Map.Entry<String, ExecutableElement> entry : getters.entrySet()) {
            void var15_15;
            ExecutableElement value = entry.getValue();
            TypeMirror returnType = value.getReturnType();
            boolean comparable = false;
            for (TypeMirror typeMirror : typeUtils.directSupertypes(returnType)) {
                TypeMirror erasure = typeUtils.erasure(typeMirror);
                if (!t2.equals(erasure)) continue;
                comparable = true;
                break;
            }
            String propertyName = entry.getKey();
            boolean primitiveType = returnType instanceof PrimitiveType;
            if (primitiveType) {
                String string = typeUtils.boxedClass((PrimitiveType)returnType).toString();
                comparable = true;
            } else {
                String string = typeUtils.erasure(returnType).toString();
            }
            boolean booleanType = returnType.toString().toLowerCase().endsWith("boolean");
            String methodName = value.getSimpleName().toString();
            methodName = methodName.startsWith("is") ? "where" + methodName.substring(2) : "where" + methodName.substring(3);
            if (booleanType) {
                methods.add(String.format("\n        public %s<%s, %s, ?> %s() {\n            return %s(\"%s\");\n        }", primitiveType ? "StreamPrimitiveBooleanQuery" : "StreamObjectBooleanQuery", className + classNameWithFormal, predicateSimpleClassName + classNameWithFormal, methodName, primitiveType ? "wherePrimitiveBoolean" : "whereBoolean", propertyName));
                continue;
            }
            if (comparable) {
                if (var15_15.contains(".String")) {
                    methods.add(String.format("\n        public StreamStringQuery<%s, %s, ?> %s() {\n            return whereString(\"%s\");\n        }", className + classNameWithFormal, predicateSimpleClassName + classNameWithFormal, methodName, propertyName));
                    continue;
                }
                methods.add(String.format("\n        public %s<%s, %s, %s, ?> %s() {\n            return %s(\"%s\");\n        }", primitiveType ? "StreamPrimitiveObjectQuery" : "StreamComparableQuery", className + classNameWithFormal, var15_15, predicateSimpleClassName + classNameWithFormal, methodName, primitiveType ? "wherePrimitive" : "whereComparable", propertyName));
                continue;
            }
            methods.add(String.format("\n        public StreamObjectQuery<%s, %s, %s, ?> %s() {\n            return where(\"%s\");\n        }", className + classNameWithFormal, var15_15, predicateSimpleClassName + classNameWithFormal, methodName, propertyName));
        }
        return String.format(STREAM_JAVA_FILE, predicateSimpleClassName, classNameWithRaw, className, classNameWithFormal, predicateSimpleClassName, classNameWithFormal, predicateSimpleClassName, className, classNameWithFormal, className, predicateSimpleClassName, className, className, classNameWithFormal, String.join((CharSequence)"\n", methods));
    }

    /*
     * WARNING - void declaration
     */
    private String generateComparatorBuilderFile(String comparatorSimpleClassName, String className, String classNameWithFormal, String classNameWithRaw, Map<String, ExecutableElement> getters) {
        LinkedList<String> methods = new LinkedList<String>();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror t2 = typeUtils.erasure(this.processingEnv.getElementUtils().getTypeElement(Comparable.class.getName()).asType());
        for (Map.Entry<String, ExecutableElement> entry : getters.entrySet()) {
            void var15_15;
            ExecutableElement value = entry.getValue();
            TypeMirror returnType = value.getReturnType();
            boolean comparable = false;
            for (TypeMirror typeMirror : typeUtils.directSupertypes(returnType)) {
                TypeMirror erasure = typeUtils.erasure(typeMirror);
                if (!t2.equals(erasure)) continue;
                comparable = true;
                break;
            }
            String propertyName = entry.getKey();
            boolean primitiveType = returnType instanceof PrimitiveType;
            if (primitiveType) {
                String string = typeUtils.boxedClass((PrimitiveType)returnType).toString();
                comparable = true;
            } else {
                String string = typeUtils.erasure(returnType).toString();
            }
            if (!comparable) continue;
            String methodName = value.getSimpleName().toString();
            methodName = methodName.startsWith("is") ? "where" + methodName.substring(2) : "where" + methodName.substring(3);
            methods.add(String.format("\n        public Query<%s, %s, %s> %s() {\n            return on(\"%s\");\n        }", className + classNameWithFormal, var15_15, comparatorSimpleClassName + classNameWithFormal, methodName, propertyName));
        }
        return String.format(COMPARATOR_JAVA_FILE, comparatorSimpleClassName, classNameWithRaw, className, classNameWithFormal, comparatorSimpleClassName, classNameWithFormal, comparatorSimpleClassName, className, comparatorSimpleClassName, className + "JavaBeanDefinition", String.join((CharSequence)"\n", methods));
    }

    private String generateInstanceBuilderFile(String instanceSimpleClassName, String className, String classNameWithFormal, String classNameWithRaw, Map<String, ExecutableElement> setters) {
        LinkedList<String> methods = new LinkedList<String>();
        Types typeUtils = this.processingEnv.getTypeUtils();
        for (Map.Entry<String, ExecutableElement> entry : setters.entrySet()) {
            ExecutableElement value = entry.getValue();
            TypeMirror methodType = value.getParameters().get(0).asType();
            String propertyName = entry.getKey();
            String returnTypeName = methodType instanceof PrimitiveType ? typeUtils.boxedClass((PrimitiveType)methodType).toString() : typeUtils.erasure(methodType).toString();
            String methodName = Introspector.decapitalize(value.getSimpleName().toString().substring(3));
            methods.add(String.format("\n        public %s %s(%s value) {\n            return set(\"%s\", value);\n        }", instanceSimpleClassName + classNameWithFormal, methodName, returnTypeName, propertyName));
        }
        return String.format(INSTANCE_JAVA_FILE, instanceSimpleClassName, classNameWithRaw, className, classNameWithFormal, instanceSimpleClassName, classNameWithFormal, instanceSimpleClassName, className, instanceSimpleClassName, className + "JavaBeanDefinition", String.join((CharSequence)"\n", methods));
    }

    private void generate(String generatedClassName, String content) throws IOException {
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(generatedClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.print(content);
        }
    }

    private void logDebug(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void logWarning(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
    }

    private static final class SettersDetector
    extends Detector {
        private final Set<String> excludeProperties;

        private SettersDetector(ProcessingEnvironment processingEnv, Set<String> excludeProperties) {
            super(processingEnv);
            this.excludeProperties = excludeProperties;
        }

        @Override
        protected String acceptExecutable(ExecutableElement e) {
            boolean result;
            String simpleName = e.getSimpleName().toString();
            boolean bl = result = simpleName.startsWith("set") && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getParameters().size() == 1 && e.getReturnType() instanceof NoType;
            if (result) {
                String propertyName = Introspector.decapitalize(simpleName.substring(3));
                return this.excludeProperties.contains(propertyName) ? null : propertyName;
            }
            return null;
        }
    }

    private static final class GettersDetector
    extends Detector {
        private final Set<String> excludeProperties;

        private GettersDetector(ProcessingEnvironment processingEnv, Set<String> excludeProperties) {
            super(processingEnv);
            this.excludeProperties = excludeProperties;
        }

        @Override
        protected String acceptExecutable(ExecutableElement e) {
            boolean result;
            String simpleName = e.getSimpleName().toString();
            boolean objectPrefix = simpleName.startsWith("get");
            boolean booleanPrefix = simpleName.startsWith("is");
            boolean bl = result = (objectPrefix || booleanPrefix) && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getParameters().isEmpty() && !(e.getReturnType() instanceof NoType);
            if (result) {
                String propertyName = Introspector.decapitalize(booleanPrefix ? simpleName.substring(2) : simpleName.substring(3));
                return this.excludeProperties.contains(propertyName) ? null : propertyName;
            }
            return null;
        }
    }

    private static abstract class Detector
    extends AbstractElementVisitor8<Map<String, ExecutableElement>, Void> {
        final Map<String, ExecutableElement> result = new TreeMap<String, ExecutableElement>();
        private ProcessingEnvironment processingEnv;
        private Types typeUtils;
        private Elements elementUtils;

        private Detector(ProcessingEnvironment processingEnv) {
            this.processingEnv = processingEnv;
            this.typeUtils = processingEnv.getTypeUtils();
            this.elementUtils = processingEnv.getElementUtils();
        }

        private void logDebug(String msg) {
            if (this.processingEnv.getOptions().containsKey("debug")) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
            }
        }

        @Override
        public final Map<String, ExecutableElement> visitPackage(PackageElement e, Void aVoid) {
            return null;
        }

        @Override
        public final Map<String, ExecutableElement> visitType(TypeElement e, Void aVoid) {
            if (e.getKind() == ElementKind.CLASS) {
                TypeElement typeElement;
                TypeMirror superclass = e.getSuperclass();
                if (superclass != null && (typeElement = this.elementUtils.getTypeElement(this.typeUtils.erasure(superclass).toString())) != null) {
                    this.visitType(typeElement, aVoid);
                }
            } else if (e.getKind() == ElementKind.INTERFACE) {
                List<? extends TypeMirror> interfaces = e.getInterfaces();
                for (TypeMirror typeMirror : interfaces) {
                    TypeElement typeElement = this.elementUtils.getTypeElement(this.typeUtils.erasure(typeMirror).toString());
                    if (typeElement == null) continue;
                    this.visitType(typeElement, aVoid);
                }
            }
            for (Element element : e.getEnclosedElements()) {
                if (element.getKind() != ElementKind.METHOD) continue;
                this.visitExecutable((ExecutableElement)element, aVoid);
            }
            return this.result;
        }

        @Override
        public final Map<String, ExecutableElement> visitVariable(VariableElement e, Void aVoid) {
            return null;
        }

        protected abstract String acceptExecutable(ExecutableElement var1);

        @Override
        public final Map<String, ExecutableElement> visitExecutable(ExecutableElement e, Void aVoid) {
            String simpleName = e.getSimpleName().toString();
            String propertyName = this.acceptExecutable(e);
            if (propertyName != null) {
                this.logDebug(String.format("%s - Found a matching method: %s (%s)", this.getClass().getSimpleName(), simpleName, propertyName));
                this.result.put(propertyName, e);
            }
            return null;
        }

        @Override
        public final Map<String, ExecutableElement> visitTypeParameter(TypeParameterElement e, Void aVoid) {
            return null;
        }
    }
}

