/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.js.templates.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import io.undertow.js.templates.Template;
import io.undertow.js.templates.TemplateProvider;
import io.undertow.js.templates.Templates;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class MustacheTemplateProvider
implements TemplateProvider {
    private volatile ResourceManager resourceManager;

    public String name() {
        return "mustache";
    }

    public void init(Map<String, String> properties, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public Template getTemplate(String templateName) {
        try {
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            final Mustache mustache = mf.compile((Reader)new StringReader(Templates.loadTemplate((String)templateName, (ResourceManager)this.resourceManager)), templateName);
            return new Template(){

                public String apply(Object data) {
                    StringWriter stringWriter = new StringWriter();
                    mustache.execute((Writer)stringWriter, data);
                    return stringWriter.getBuffer().toString();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

