/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.DateHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.DateUtils;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DateHandlerTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler((HttpHandler)new DateHandler((HttpHandler)ResponseCodeHandler.HANDLE_200));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateHandler() throws IOException, InterruptedException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header date = result.getHeaders("Date")[0];
            long firstDate = DateUtils.parseDate((String)date.getValue()).getTime();
            Assert.assertTrue((firstDate + 3000L > System.currentTimeMillis() ? 1 : 0) != 0);
            Assert.assertTrue((System.currentTimeMillis() > firstDate ? 1 : 0) != 0);
            HttpClientUtils.readResponse(result);
            Thread.sleep(1500L);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            date = result.getHeaders("Date")[0];
            long secondDate = DateUtils.parseDate((String)date.getValue()).getTime();
            Assert.assertTrue((secondDate + 2000L > System.currentTimeMillis() ? 1 : 0) != 0);
            Assert.assertTrue((System.currentTimeMillis() > secondDate ? 1 : 0) != 0);
            Assert.assertTrue((secondDate > firstDate ? 1 : 0) != 0);
            HttpClientUtils.readResponse(result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

