/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class HttpClientUtils {
    private HttpClientUtils() {
    }

    public static String readResponse(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return "";
        }
        return HttpClientUtils.readResponse(entity.getContent());
    }

    public static String readResponse(InputStream stream) throws IOException {
        int read;
        StringBuilder builder = new StringBuilder();
        byte[] data = new byte[100];
        while ((read = stream.read(data)) != -1) {
            builder.append(new String(data, 0, read, "UTF-8"));
        }
        return builder.toString();
    }

    public static byte[] readRawResponse(HttpResponse response) throws IOException {
        return HttpClientUtils.readRawResponse(response.getEntity().getContent());
    }

    public static byte[] readRawResponse(InputStream stream) throws IOException {
        int read;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        byte[] data = new byte[100];
        while ((read = stream.read(data)) != -1) {
            b.write(data, 0, read);
        }
        return b.toByteArray();
    }
}

