/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.handler.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class AutobahnWebSocketServer {
    private HttpOpenListener openListener;
    private XnioWorker worker;
    private AcceptingChannel<StreamConnection> server;
    private Xnio xnio;
    private final int port;

    public AutobahnWebSocketServer(int port) {
        this.port = port;
    }

    public void run() {
        this.xnio = Xnio.getInstance((String)"nio");
        try {
            this.worker = this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_WRITE_THREADS, 4).set(Options.WORKER_READ_THREADS, 4).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 10).set(Options.WORKER_TASK_MAX_THREADS, 12).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
            OptionMap serverOptions = OptionMap.builder().set(Options.WORKER_ACCEPT_THREADS, 4).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
            this.openListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 0x4000000), 8192);
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            this.server = this.worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(this.port), acceptListener, serverOptions);
            this.setRootHandler((HttpHandler)AutobahnWebSocketServer.getRootHandler());
            this.server.resumeAccepts();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static WebSocketProtocolHandshakeHandler getRootHandler() {
        return new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                channel.getReceiveSetter().set((ChannelListener)new Receiver());
                channel.resumeReceives();
            }
        });
    }

    private void setRootHandler(HttpHandler rootHandler) {
        this.openListener.setRootHandler(rootHandler);
    }

    public static void main(String[] args) {
        new AutobahnWebSocketServer(7777).run();
    }

    private static final class Receiver
    implements ChannelListener<WebSocketChannel> {
        private Receiver() {
        }

        public void handleEvent(WebSocketChannel channel) {
            try {
                StreamSourceFrameChannel ws = channel.receive();
                if (ws != null) {
                    WebSocketUtils.echoFrame((WebSocketChannel)channel, (StreamSourceFrameChannel)ws);
                }
                channel.resumeReceives();
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }
}

