/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.NetworkUtils;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class VirtualHostTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVirtualHost() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            NameVirtualHostHandler handler = new NameVirtualHostHandler().addHost(NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")), (HttpHandler)new SetHeaderHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, "myHost", "localhost")).setDefaultHandler((HttpHandler)new SetHeaderHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, "myHost", "default"));
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("myHost");
            Assert.assertEquals((Object)"localhost", (Object)header[0].getValue());
            HttpClientUtils.readResponse(result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("Host", "otherHost");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders("myHost");
            Assert.assertEquals((Object)"default", (Object)header[0].getValue());
            HttpClientUtils.readResponse(result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

