/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.xnio.Pool;
import org.xnio.Pooled;

public class DebuggingSlicePool
implements Pool<ByteBuffer> {
    private static final ThreadLocal<String> ALLOCATION_CONTEXT = new ThreadLocal();
    static final Set<DebuggingBuffer> BUFFERS = Collections.newSetFromMap(new ConcurrentHashMap());
    static volatile String currentLabel;
    private final Pool<ByteBuffer> delegate;

    public DebuggingSlicePool(Pool<ByteBuffer> delegate) {
        this.delegate = delegate;
    }

    public static void addContext(String context) {
        ALLOCATION_CONTEXT.set(context);
    }

    public Pooled<ByteBuffer> allocate() {
        Pooled delegate = this.delegate.allocate();
        return new DebuggingBuffer((Pooled<ByteBuffer>)delegate, currentLabel);
    }

    static class DebuggingBuffer
    implements Pooled<ByteBuffer> {
        private static final AtomicInteger allocationCount = new AtomicInteger();
        private final RuntimeException allocationPoint;
        private final Pooled<ByteBuffer> delegate;
        private final String label;
        private final int no;
        private volatile boolean free = false;
        private RuntimeException freePoint;

        public DebuggingBuffer(Pooled<ByteBuffer> delegate, String label) {
            this.delegate = delegate;
            this.label = label;
            this.no = allocationCount.getAndIncrement();
            String ctx = (String)ALLOCATION_CONTEXT.get();
            ALLOCATION_CONTEXT.remove();
            this.allocationPoint = new RuntimeException(delegate.getResource() + " NO: " + this.no + " " + (ctx == null ? "[NO_CONTEXT]" : ctx));
            BUFFERS.add(this);
        }

        public void discard() {
            BUFFERS.remove(this);
            this.delegate.discard();
        }

        public void free() {
            if (this.free) {
                return;
            }
            this.freePoint = new RuntimeException("FREE POINT");
            this.free = true;
            BUFFERS.remove(this);
            this.delegate.free();
        }

        public ByteBuffer getResource() throws IllegalStateException {
            if (this.free) {
                throw new IllegalStateException("Buffer already freed, free point: ", this.freePoint);
            }
            return (ByteBuffer)this.delegate.getResource();
        }

        public void close() {
        }

        RuntimeException getAllocationPoint() {
            return this.allocationPoint;
        }

        String getLabel() {
            return this.label;
        }

        public String toString() {
            return "[debug]" + this.delegate.toString();
        }
    }
}

