/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.utils;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.jboss.netty.util.CharsetUtil;

public final class WebSocketTestClient {
    private final ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory());
    private Channel ch;
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean closed;
    private static final AtomicInteger count = new AtomicInteger();

    public WebSocketTestClient(WebSocketVersion version, URI uri) {
        this.uri = uri;
        this.version = version;
    }

    public WebSocketTestClient connect() throws Exception {
        String protocol = this.uri.getScheme();
        if (!"ws".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        final WebSocketClientHandshaker handshaker = new WebSocketClientHandshakerFactory().newHandshaker(this.uri, this.version, null, false, Collections.emptyMap());
        final CountDownLatch handshakeLatch = new CountDownLatch(1);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
                pipeline.addLast("ws-handler", (ChannelHandler)new WSClientHandler(handshaker, handshakeLatch));
                return pipeline;
            }
        });
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.uri.getHost(), this.uri.getPort()));
        future.syncUninterruptibly();
        this.ch = future.getChannel();
        handshaker.handshake(this.ch).syncUninterruptibly();
        handshakeLatch.await();
        return this;
    }

    public WebSocketTestClient send(WebSocketFrame frame, final FrameListener listener) {
        this.ch.getPipeline().addLast("responseHandler" + count.incrementAndGet(), (ChannelHandler)new SimpleChannelUpstreamHandler(){

            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                if (e.getMessage() instanceof CloseWebSocketFrame) {
                    WebSocketTestClient.this.closed = true;
                }
                listener.onFrame((WebSocketFrame)e.getMessage());
                ctx.getPipeline().remove((ChannelHandler)this);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
                listener.onError(e.getCause());
                ctx.getPipeline().remove((ChannelHandler)this);
            }
        });
        ChannelFuture cf = this.ch.write((Object)frame).syncUninterruptibly();
        if (!cf.isSuccess()) {
            listener.onError(cf.getCause());
        }
        return this;
    }

    public void destroy() {
        if (!this.closed) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.send((WebSocketFrame)new CloseWebSocketFrame(), new FrameListener(){

                @Override
                public void onFrame(WebSocketFrame frame) {
                    latch.countDown();
                }

                @Override
                public void onError(Throwable t) {
                    latch.countDown();
                }
            });
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.bootstrap.releaseExternalResources();
        if (this.ch != null) {
            this.ch.close().syncUninterruptibly();
        }
    }

    private static final class WSClientHandler
    extends SimpleChannelUpstreamHandler {
        private final WebSocketClientHandshaker handshaker;
        private final CountDownLatch handshakeLatch;

        public WSClientHandler(WebSocketClientHandshaker handshaker, CountDownLatch handshakeLatch) {
            this.handshaker = handshaker;
            this.handshakeLatch = handshakeLatch;
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Channel ch = ctx.getChannel();
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, (HttpResponse)e.getMessage());
                this.handshakeLatch.countDown();
                return;
            }
            if (e.getMessage() instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)e.getMessage();
                throw new Exception("Unexpected HttpResponse (status=" + response.getStatus() + ", content=" + response.getContent().toString(CharsetUtil.UTF_8) + ')');
            }
            super.messageReceived(ctx, e);
        }
    }

    public static interface FrameListener {
        public void onFrame(WebSocketFrame var1);

        public void onError(Throwable var1);
    }
}

