/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class PredicatedHandlersTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRewrite() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)Handlers.predicates((List)PredicatedHandlersParser.parse((String)"method[GET] -> set[attribute='%{o,type}', value=get]\nregex['(.*).css'] -> rewrite['${1}.xcss'] -> set[attribute='%{o,chained}', value=true]\nregex['(.*).redirect$'] -> redirect['${1}.redirected']\nset[attribute='%{o,someHeader}', value=always]\npath-template['/foo/{bar}/{f}'] -> set[attribute='%{o,template}', value='${bar}']", (ClassLoader)this.getClass().getClassLoader()), (HttpHandler)new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send(exchange.getRelativePath());
            }
        }));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/foo/a/b");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"get", (Object)result.getHeaders("type")[0].getValue());
            Assert.assertEquals((Object)"always", (Object)result.getHeaders("someHeader")[0].getValue());
            Assert.assertEquals((Object)"a", (Object)result.getHeaders("template")[0].getValue());
            Assert.assertEquals((Object)"/foo/a/b", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/foo/a/b.css");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"get", (Object)result.getHeaders("type")[0].getValue());
            Assert.assertEquals((Object)"true", (Object)result.getHeaders("chained")[0].getValue());
            Assert.assertEquals((Object)"always", (Object)result.getHeaders("someHeader")[0].getValue());
            Assert.assertEquals((Object)"a", (Object)result.getHeaders("template")[0].getValue());
            Assert.assertEquals((Object)"/foo/a/b.xcss", (Object)response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/foo/a/b.redirect");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"get", (Object)result.getHeaders("type")[0].getValue());
            Assert.assertEquals((Object)"always", (Object)result.getHeaders("someHeader")[0].getValue());
            Assert.assertEquals((Object)"a", (Object)result.getHeaders("template")[0].getValue());
            Assert.assertEquals((Object)"/foo/a/b.redirected", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

