/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.JvmRouteHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.AbstractLoadBalancingProxyTestCase;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
public class LoadBalancingProxySPDYTestCase
extends AbstractLoadBalancingProxyTestCase {
    @BeforeClass
    public static void setup() throws URISyntaxException {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        int port = DefaultServer.getHostPort("default");
        final JvmRouteHandler handler1 = Handlers.jvmRoute((String)"JSESSIONID", (String)"s1", (HttpHandler)Handlers.path().addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new AbstractLoadBalancingProxyTestCase.SessionTestHandler(sessionConfig), (SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig)).addPrefixPath("/name", (HttpHandler)new AbstractLoadBalancingProxyTestCase.StringSendHandler("server1")));
        server1 = Undertow.builder().addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_SPDY, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!exchange.getRequestHeaders().contains(":method")) {
                    throw new RuntimeException("Not SPDY");
                }
                System.out.println(exchange.getRequestHeaders());
                handler1.handleRequest(exchange);
            }
        }).build();
        final JvmRouteHandler handler2 = Handlers.jvmRoute((String)"JSESSIONID", (String)"s2", (HttpHandler)Handlers.path().addPrefixPath("/session", (HttpHandler)new SessionAttachmentHandler((HttpHandler)new AbstractLoadBalancingProxyTestCase.SessionTestHandler(sessionConfig), (SessionManager)new InMemorySessionManager(""), (SessionConfig)sessionConfig)).addPrefixPath("/name", (HttpHandler)new AbstractLoadBalancingProxyTestCase.StringSendHandler("server2")));
        server2 = Undertow.builder().addHttpsListener(port + 2, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_SPDY, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!exchange.getRequestHeaders().contains(":method")) {
                    throw new RuntimeException("Not SPDY");
                }
                System.out.println(exchange.getRequestHeaders());
                handler2.handleRequest(exchange);
            }
        }).build();
        server1.start();
        server2.start();
        UndertowXnioSsl ssl = new UndertowXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, (Pool)DefaultServer.SSL_BUFFER_POOL, DefaultServer.createClientSslContext());
        DefaultServer.setRootHandler((HttpHandler)new ProxyHandler((ProxyClient)new LoadBalancingProxyClient().setConnectionsPerThread(1).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), port + 1, null, null, null), "s1", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_SPDY, (Object)true)).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), port + 2, null, null, null), "s2", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_SPDY, (Object)true)), 10000, (HttpHandler)ResponseCodeHandler.HANDLE_404));
    }

    @Before
    public void requireAlpn() {
        DefaultServer.assumeAlpnEnabled();
    }
}

