/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.handlers.proxy.mod_cluster.AbstractModClusterTestBase;
import io.undertow.server.handlers.proxy.mod_cluster.NodeTestConfig;
import io.undertow.testutils.HttpClientUtils;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BasicMCMPUnitTestCase
extends AbstractModClusterTestBase {
    static NodeTestConfig server1 = NodeTestConfig.builder().setJvmRoute("s1").setType(BasicMCMPUnitTestCase.getType()).setHostname("localhost").setPort(port + 1);
    static NodeTestConfig server2 = NodeTestConfig.builder().setJvmRoute("s2").setType(BasicMCMPUnitTestCase.getType()).setHostname("localhost").setPort(port + 2);

    @BeforeClass
    public static void setup() {
        BasicMCMPUnitTestCase.startServers(server1, server2);
    }

    @AfterClass
    public static void tearDown() {
        BasicMCMPUnitTestCase.stopServers();
    }

    @Test
    public void testBasic() throws IOException {
        HttpResponse result;
        HttpGet get;
        int i;
        this.registerNodes(false, server1, server2);
        modClusterClient.updateLoad("s1", 100);
        modClusterClient.updateLoad("s2", 1);
        modClusterClient.enableApp("s1", "/name", "localhost", "localhost:7777");
        modClusterClient.enableApp("s1", "/session", "localhost", "localhost:7777");
        modClusterClient.enableApp("s2", "/name", "localhost", "localhost:7777");
        modClusterClient.enableApp("s2", "/session", "localhost", "localhost:7777");
        modClusterClient.updateLoad("s1", -2);
        modClusterClient.updateLoad("s2", -2);
        for (i = 0; i < 10; ++i) {
            get = BasicMCMPUnitTestCase.get("/name");
            result = httpClient.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
        }
        for (i = 0; i < 10; ++i) {
            get = BasicMCMPUnitTestCase.get("/session");
            result = httpClient.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
        }
    }

    @Test
    public void testAppCommand() throws IOException {
        BasicMCMPUnitTestCase.checkGet("/name", 404);
        BasicMCMPUnitTestCase.checkGet("/session", 404);
        this.registerNodes(false, server1, server2);
        BasicMCMPUnitTestCase.checkGet("/name", 404);
        BasicMCMPUnitTestCase.checkGet("/session", 404);
        modClusterClient.enableApp("s1", "/name", "localhost", "localhost:7777");
        modClusterClient.enableApp("s1", "/session", "localhost", "localhost:7777");
        modClusterClient.enableApp("s2", "/name", "localhost", "localhost:7777");
        modClusterClient.enableApp("s2", "/session", "localhost", "localhost:7777");
        BasicMCMPUnitTestCase.checkGet("/name", 503);
        BasicMCMPUnitTestCase.checkGet("/session", 503);
        modClusterClient.updateLoad("s1", 100);
        modClusterClient.updateLoad("s2", 1);
        BasicMCMPUnitTestCase.checkGet("/name", 200);
        BasicMCMPUnitTestCase.checkGet("/session", 200);
    }

    @Test
    public void testErrorState() throws IOException {
        this.registerNodes(false, server1);
        modClusterClient.enableApp("s1", "/name", "localhost", "localhost:7777");
        BasicMCMPUnitTestCase.checkGet("/name", 503);
        modClusterClient.updateLoad("s1", 1);
        BasicMCMPUnitTestCase.checkGet("/name", 200);
        modClusterClient.updateLoad("s1", -1);
        BasicMCMPUnitTestCase.checkGet("/name", 503);
        modClusterClient.updateLoad("s1", -2);
        BasicMCMPUnitTestCase.checkGet("/name", 503);
    }

    @Test
    public void testPing() throws IOException {
        String response = modClusterClient.ping(null, "localhost", port + 1);
        Assert.assertFalse((boolean)response.contains("NOTOK"));
        response = modClusterClient.ping(server1.getType(), "localhost", port + 1);
        Assert.assertFalse((boolean)response.contains("NOTOK"));
        response = modClusterClient.ping(server2.getType(), "localhost", port + 2);
        Assert.assertFalse((boolean)response.contains("NOTOK"));
        response = modClusterClient.ping(null, "localhost", 0);
        Assert.assertTrue((boolean)response.contains("NOTOK"));
        response = modClusterClient.ping("ajp", "localhost", 0);
        Assert.assertTrue((boolean)response.contains("NOTOK"));
        response = modClusterClient.ping("http", "localhost", 0);
        Assert.assertTrue((boolean)response.contains("NOTOK"));
    }
}

