/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client.version13;

import io.undertow.Undertow;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ConnectHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.util.StringWriteChannelListener;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.protocol.server.AutobahnWebSocketServer;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
public class WebSocketClient13TestCase {
    private static XnioWorker worker;
    private static Undertow server;
    private static final Deque<String> connectLog;
    private final Pool<ByteBuffer> buffer = new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, 1024, 1024);

    @BeforeClass
    public static void setup() throws IOException {
        DefaultServer.setRootHandler((HttpHandler)AutobahnWebSocketServer.getRootHandler());
        Xnio xnio = Xnio.getInstance((ClassLoader)DefaultServer.class.getClassLoader());
        worker = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 2).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
        final ConnectHandler handler = new ConnectHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.setResponseCode(500);
            }
        });
        DefaultServer.startSSLServer();
        server = Undertow.builder().addHttpListener(DefaultServer.getHostPort("default") + 10, DefaultServer.getHostAddress("default")).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                connectLog.add(exchange.getRequestMethod() + " " + exchange.getRelativePath());
                handler.handleRequest(exchange);
            }
        }).build();
        server.start();
    }

    @AfterClass
    public static void stop() throws IOException {
        server.stop();
        server = null;
        DefaultServer.stopSSLServer();
    }

    @AfterClass
    public static void shutdown() {
        worker.shutdown();
    }

    @Test
    public void testTextMessage() throws Exception {
        WebSocketChannel webSocketChannel = (WebSocketChannel)WebSocketClient.connectionBuilder((XnioWorker)worker, this.buffer, (URI)new URI(DefaultServer.getDefaultServerURL())).connect().get();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        webSocketChannel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

            protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                String data = message.getData();
                result.set(data);
                latch.countDown();
            }

            protected void onError(WebSocketChannel channel, Throwable error) {
                super.onError(channel, error);
                error.printStackTrace();
                latch.countDown();
            }
        });
        webSocketChannel.resumeReceives();
        StreamSinkFrameChannel sendChannel = webSocketChannel.send(WebSocketFrameType.TEXT, 11L);
        new StringWriteChannelListener("Hello World").setup((StreamSinkChannel)sendChannel);
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"Hello World", result.get());
        webSocketChannel.sendClose();
    }

    @Test
    @ProxyIgnore
    public void testMessageViaProxy() throws Exception {
        WebSocketChannel webSocketChannel = (WebSocketChannel)WebSocketClient.connectionBuilder((XnioWorker)worker, this.buffer, (URI)new URI(DefaultServer.getDefaultServerURL())).setProxyUri(new URI("http", null, DefaultServer.getHostAddress("default"), DefaultServer.getHostPort("default") + 10, "/proxy", null, null)).connect().get();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        webSocketChannel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

            protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                String data = message.getData();
                result.set(data);
                latch.countDown();
            }

            protected void onError(WebSocketChannel channel, Throwable error) {
                super.onError(channel, error);
                error.printStackTrace();
                latch.countDown();
            }
        });
        webSocketChannel.resumeReceives();
        StreamSinkFrameChannel sendChannel = webSocketChannel.send(WebSocketFrameType.TEXT, 11L);
        new StringWriteChannelListener("Hello World").setup((StreamSinkChannel)sendChannel);
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"Hello World", result.get());
        webSocketChannel.sendClose();
        Assert.assertEquals((Object)("CONNECT " + DefaultServer.getHostAddress("default") + ":" + DefaultServer.getHostPort("default")), (Object)connectLog.poll());
    }

    @Test
    @ProxyIgnore
    public void testMessageViaWssProxy() throws Exception {
        WebSocketChannel webSocketChannel = (WebSocketChannel)WebSocketClient.connectionBuilder((XnioWorker)worker, this.buffer, (URI)new URI(DefaultServer.getDefaultServerSSLAddress())).setSsl((XnioSsl)new UndertowXnioSsl(Xnio.getInstance(), OptionMap.EMPTY, DefaultServer.getClientSSLContext())).setProxyUri(new URI("http", null, DefaultServer.getHostAddress("default"), DefaultServer.getHostPort("default") + 10, "/proxy", null, null)).connect().get();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        webSocketChannel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

            protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                String data = message.getData();
                result.set(data);
                latch.countDown();
            }

            protected void onError(WebSocketChannel channel, Throwable error) {
                super.onError(channel, error);
                error.printStackTrace();
                latch.countDown();
            }
        });
        webSocketChannel.resumeReceives();
        StreamSinkFrameChannel sendChannel = webSocketChannel.send(WebSocketFrameType.TEXT, 11L);
        new StringWriteChannelListener("Hello World").setup((StreamSinkChannel)sendChannel);
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"Hello World", result.get());
        webSocketChannel.sendClose();
        Assert.assertEquals((Object)("CONNECT " + DefaultServer.getHostAddress("default") + ":" + DefaultServer.getHostSSLPort("default")), (Object)connectLog.poll());
    }

    static {
        connectLog = new LinkedBlockingDeque<String>();
    }
}

