/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.error;

import io.undertow.Handlers;
import io.undertow.UndertowLogger;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.Headers;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class FileErrorPageHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.error.file");
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private volatile Set<Integer> responseCodes;
    private volatile Path file;
    private final MimeMappings mimeMappings;

    @Deprecated
    public FileErrorPageHandler(File file, Integer ... responseCodes) {
        this(file.toPath(), responseCodes);
    }

    public FileErrorPageHandler(Path file, Integer ... responseCodes) {
        this.file = file;
        this.responseCodes = new HashSet<Integer>(Arrays.asList(responseCodes));
        this.mimeMappings = MimeMappings.DEFAULT;
    }

    @Deprecated
    public FileErrorPageHandler(HttpHandler next, File file, Integer ... responseCodes) {
        this(next, file.toPath(), responseCodes);
    }

    public FileErrorPageHandler(HttpHandler next, Path file, Integer ... responseCodes) {
        this(next, file, MimeMappings.DEFAULT, responseCodes);
    }

    public FileErrorPageHandler(HttpHandler next, Path file, MimeMappings mimeMappings, Integer ... responseCodes) {
        this.next = next;
        this.file = file;
        this.responseCodes = new HashSet<Integer>(Arrays.asList(responseCodes));
        this.mimeMappings = mimeMappings;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addDefaultResponseListener(new DefaultResponseListener(){

            @Override
            public boolean handleDefaultResponse(HttpServerExchange exchange) {
                Set codes = FileErrorPageHandler.this.responseCodes;
                if (!exchange.isResponseStarted() && codes.contains(exchange.getResponseCode())) {
                    FileErrorPageHandler.this.serveFile(exchange);
                    return true;
                }
                return false;
            }
        });
        this.next.handleRequest(exchange);
    }

    private void serveFile(final HttpServerExchange exchange) {
        String contentType;
        String fileName = this.file.toString();
        int index = fileName.lastIndexOf(".");
        if (index > 0 && (contentType = this.mimeMappings.getMimeType(fileName.substring(index + 1))) != null) {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
        }
        exchange.dispatch(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long size;
                FileChannel fileChannel;
                try {
                    try {
                        fileChannel = FileChannel.open(FileErrorPageHandler.this.file, StandardOpenOption.READ);
                    }
                    catch (FileNotFoundException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        exchange.endExchange();
                        return;
                    }
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    exchange.endExchange();
                    return;
                }
                try {
                    size = Files.size(FileErrorPageHandler.this.file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, size);
                StreamSinkChannel response = exchange.getResponseChannel();
                exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                    @Override
                    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        IoUtils.safeClose((Closeable)fileChannel);
                        nextListener.proceed();
                    }
                });
                try {
                    log.tracef("Serving file %s (blocking)", (Object)fileChannel);
                    Channels.transferBlocking((StreamSinkChannel)response, (FileChannel)fileChannel, (long)0L, (long)Files.size(FileErrorPageHandler.this.file));
                    log.tracef("Finished serving %s, shutting down (blocking)", (Object)fileChannel);
                    response.shutdownWrites();
                    log.tracef("Finished serving %s, flushing (blocking)", (Object)fileChannel);
                    Channels.flushBlocking((SuspendableWriteChannel)response);
                    log.tracef("Finished serving %s (complete)", (Object)fileChannel);
                    exchange.endExchange();
                }
                catch (IOException ignored) {
                    log.tracef("Failed to serve %s: %s", (Object)fileChannel, (Object)ignored);
                    exchange.endExchange();
                    IoUtils.safeClose((Closeable)response);
                }
                finally {
                    IoUtils.safeClose((Closeable)fileChannel);
                }
            }
        });
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public FileErrorPageHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public Set<Integer> getResponseCodes() {
        return Collections.unmodifiableSet(this.responseCodes);
    }

    public FileErrorPageHandler setResponseCodes(Set<Integer> responseCodes) {
        this.responseCodes = responseCodes == null ? Collections.emptySet() : new HashSet<Integer>(responseCodes);
        return this;
    }

    public FileErrorPageHandler setResponseCodes(Integer ... responseCodes) {
        this.responseCodes = new HashSet<Integer>(Arrays.asList(responseCodes));
        return this;
    }

    public Path getFile() {
        return this.file;
    }

    public FileErrorPageHandler setFile(Path file) {
        this.file = file;
        return this;
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String file;
        private final Integer[] responseCodes;

        private Wrapper(String file, Integer[] responseCodes) {
            this.file = file;
            this.responseCodes = responseCodes;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new FileErrorPageHandler(handler, Paths.get(this.file, new String[0]), this.responseCodes);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "error-file";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("file", String.class);
            params.put("response-codes", Integer[].class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return new HashSet<String>(Arrays.asList("file", "response-codes"));
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String)config.get("file"), (Integer[])config.get("response-codes"));
        }
    }
}

