/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyProtocolUtils;
import io.undertow.protocols.spdy.SpdyPushBackParser;
import io.undertow.protocols.spdy.StreamErrorException;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

abstract class SpdyHeaderBlockParser
extends SpdyPushBackParser {
    private final SpdyChannel channel;
    private int numHeaders = -1;
    private int readHeaders = 0;
    private final HeaderMap headerMap = new HeaderMap();
    private final Inflater inflater;
    private HttpString currentHeader;
    private ByteArrayOutputStream partialValue;
    private int remainingData;
    private boolean beforeHeadersHandled = false;
    private byte[] dataOverflow;

    SpdyHeaderBlockParser(SpdyChannel channel, int frameLength, Inflater inflater) {
        super(frameLength);
        this.channel = channel;
        this.inflater = inflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleData(ByteBuffer resource) throws IOException {
        if (!this.beforeHeadersHandled && !this.handleBeforeHeader(resource)) {
            return;
        }
        this.beforeHeadersHandled = true;
        PooledByteBuffer outPooled = this.channel.getHeapBufferPool().allocate();
        PooledByteBuffer inPooled = this.channel.getHeapBufferPool().allocate();
        boolean extraOutput = false;
        try {
            ByteBuffer outputBuffer = outPooled.getBuffer();
            ByteBuffer inPooledResource = inPooled.getBuffer();
            if (this.dataOverflow != null) {
                outputBuffer.put(this.dataOverflow);
                this.dataOverflow = null;
                extraOutput = true;
            }
            byte[] inputBuffer = inPooledResource.array();
            while (resource.hasRemaining()) {
                int rem = resource.remaining();
                if (rem > inputBuffer.length) {
                    resource.get(inputBuffer, inPooledResource.arrayOffset(), inPooledResource.limit());
                } else {
                    resource.get(inputBuffer, inPooledResource.arrayOffset(), resource.remaining());
                }
                int inputLength = Math.min(rem, inPooledResource.limit());
                this.inflater.setInput(inputBuffer, inPooledResource.arrayOffset(), inputLength);
                while (!this.inflater.needsInput()) {
                    int copied = 0;
                    try {
                        copied = this.inflater.inflate(outputBuffer.array(), outputBuffer.arrayOffset() + outputBuffer.position(), outputBuffer.remaining());
                    }
                    catch (DataFormatException e) {
                        throw new StreamErrorException(1);
                    }
                    if (copied == 0 && this.inflater.needsDictionary()) {
                        this.inflater.setDictionary(SpdyProtocolUtils.SPDY_DICT);
                        continue;
                    }
                    if (copied <= 0) continue;
                    outputBuffer.position(outputBuffer.position() + copied);
                    this.handleDecompressedData(outputBuffer);
                    if (outputBuffer.hasRemaining()) {
                        outputBuffer.compact();
                        extraOutput = true;
                        continue;
                    }
                    extraOutput = false;
                    outputBuffer.clear();
                }
            }
        }
        finally {
            if (extraOutput) {
                outPooled.getBuffer().flip();
                this.dataOverflow = new byte[outPooled.getBuffer().remaining()];
                outPooled.getBuffer().get(this.dataOverflow);
            }
            inPooled.close();
            outPooled.close();
        }
    }

    protected abstract boolean handleBeforeHeader(ByteBuffer var1);

    /*
     * Enabled aggressive block sorting
     */
    private void handleDecompressedData(ByteBuffer data) throws IOException {
        data.flip();
        if (this.numHeaders == -1) {
            if (data.remaining() < 4) {
                return;
            }
            this.numHeaders = (data.get() & 0xFF) << 24;
            this.numHeaders += (data.get() & 0xFF) << 16;
            this.numHeaders += (data.get() & 0xFF) << 8;
            this.numHeaders += data.get() & 0xFF;
        }
        while (true) {
            block21: {
                int end;
                int start;
                if (this.readHeaders >= this.numHeaders) {
                    return;
                }
                if (this.currentHeader == null && this.partialValue == null) {
                    if (data.remaining() < 4) {
                        return;
                    }
                    int nameLength = (data.get() & 0xFF) << 24;
                    nameLength += (data.get() & 0xFF) << 16;
                    nameLength += (data.get() & 0xFF) << 8;
                    if ((nameLength += data.get() & 0xFF) == 0) {
                        throw new StreamErrorException(1);
                    }
                    if (data.remaining() < nameLength) {
                        this.remainingData = nameLength - data.remaining();
                        this.partialValue = new ByteArrayOutputStream();
                        this.partialValue.write(data.array(), data.arrayOffset() + data.position(), data.remaining());
                        data.position(data.limit());
                        return;
                    }
                    this.currentHeader = new HttpString(data.array(), data.arrayOffset() + data.position(), nameLength);
                    data.position(data.position() + nameLength);
                } else if (this.currentHeader == null && this.partialValue != null) {
                    if (data.remaining() < this.remainingData) {
                        this.remainingData -= data.remaining();
                        this.partialValue.write(data.array(), data.arrayOffset() + data.position(), data.remaining());
                        data.position(data.limit());
                        return;
                    }
                    this.partialValue.write(data.array(), data.arrayOffset() + data.position(), this.remainingData);
                    this.currentHeader = new HttpString(this.partialValue.toByteArray());
                    data.position(data.position() + this.remainingData);
                    this.remainingData = -1;
                    this.partialValue = null;
                }
                if (this.partialValue == null) {
                    int i;
                    byte[] array;
                    if (data.remaining() < 4) {
                        return;
                    }
                    int valueLength = (data.get() & 0xFF) << 24;
                    valueLength += (data.get() & 0xFF) << 16;
                    valueLength += (data.get() & 0xFF) << 8;
                    if (data.remaining() >= (valueLength += data.get() & 0xFF)) {
                        start = data.arrayOffset() + data.position();
                        end = start + valueLength;
                        array = data.array();
                        for (i = start; i < end; ++i) {
                            if (array[i] != 0) continue;
                            this.headerMap.add(this.currentHeader, new String(array, start, i - start, StandardCharsets.UTF_8));
                            start = i + 1;
                        }
                        this.headerMap.add(this.currentHeader, new String(array, start, end - start, StandardCharsets.UTF_8));
                        this.currentHeader = null;
                        data.position(data.position() + valueLength);
                        break block21;
                    } else {
                        this.remainingData = valueLength - data.remaining();
                        start = data.arrayOffset() + data.position();
                        end = start + data.remaining();
                        array = data.array();
                        i = start;
                        while (true) {
                            if (i >= end) {
                                this.partialValue = new ByteArrayOutputStream();
                                this.partialValue.write(array, start, end - start);
                                data.position(data.limit());
                                return;
                            }
                            if (array[i] == 0) {
                                String headerValue = new String(array, start, i - start - 1, StandardCharsets.UTF_8);
                                this.headerMap.add(this.currentHeader, headerValue);
                                start = i + 1;
                            }
                            ++i;
                        }
                    }
                }
                if (data.remaining() < this.remainingData) {
                    this.remainingData -= data.remaining();
                    this.partialValue.write(data.array(), data.arrayOffset() + data.position(), data.remaining());
                    data.position(data.limit());
                    return;
                }
                this.partialValue.write(data.array(), data.arrayOffset() + data.position(), this.remainingData);
                byte[] completeData = this.partialValue.toByteArray();
                start = 0;
                end = completeData.length;
                for (int i = start; i < end; ++i) {
                    if (completeData[i] != 0) continue;
                    this.headerMap.add(this.currentHeader, new String(completeData, start, i - start - 1, StandardCharsets.UTF_8));
                    start = i + 1;
                }
                this.headerMap.add(this.currentHeader, new String(completeData, start, end - start, StandardCharsets.UTF_8));
                data.position(data.position() + this.remainingData);
                this.currentHeader = null;
                this.remainingData = -1;
                this.partialValue = null;
            }
            ++this.readHeaders;
        }
    }

    HeaderMap getHeaderMap() {
        return this.headerMap;
    }
}

