/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.util.ImmediatePooledByteBuffer;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.extensions.ExtensionFunction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.xnio.Buffers;

public class PerMessageDeflateFunction
implements ExtensionFunction {
    public static final byte[] TAIL = new byte[]{0, 0, -1, -1};
    private final int deflaterLevel;
    private final boolean compressContextTakeover;
    private final boolean decompressContextTakeover;
    private final Inflater decompress;
    private final Deflater compress;
    private StreamSourceFrameChannel currentReadChannel;

    public PerMessageDeflateFunction(int deflaterLevel, boolean compressContextTakeover, boolean decompressContextTakeover) {
        this.deflaterLevel = deflaterLevel;
        this.decompress = new Inflater(true);
        this.compress = new Deflater(this.deflaterLevel, true);
        this.compressContextTakeover = compressContextTakeover;
        this.decompressContextTakeover = decompressContextTakeover;
    }

    @Override
    public int writeRsv(int rsv) {
        return rsv | 4;
    }

    @Override
    public boolean hasExtensionOpCode() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PooledByteBuffer transformForWrite(PooledByteBuffer pooledBuffer, WebSocketChannel wsChannel) throws IOException {
        StreamSinkFrameChannel channel = wsChannel.getExtensionSinkChannel();
        boolean lastFrame = wsChannel.isExtensionSinkLastFrame();
        ByteBuffer buffer = pooledBuffer.getBuffer();
        if (buffer.hasArray()) {
            this.compress.setInput(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            this.compress.setInput(Buffers.take((ByteBuffer)buffer));
        }
        PooledByteBuffer output = this.allocateBufferWithArray(channel.getWebSocketChannel(), 0);
        ByteBuffer outputBuffer = output.getBuffer();
        boolean onceOnly = true;
        try {
            while (!this.compress.needsInput() && !this.compress.finished() || !outputBuffer.hasRemaining() || onceOnly && lastFrame) {
                onceOnly = false;
                if (!outputBuffer.hasRemaining()) {
                    output = this.largerBuffer(output, channel.getWebSocketChannel(), outputBuffer.capacity() * 2);
                    outputBuffer = output.getBuffer();
                }
                int n = this.compress.deflate(outputBuffer.array(), outputBuffer.arrayOffset() + outputBuffer.position(), outputBuffer.remaining(), lastFrame ? 2 : 0);
                outputBuffer.position(outputBuffer.position() + n);
            }
        }
        finally {
            pooledBuffer.close();
        }
        if (lastFrame) {
            outputBuffer.put((byte)0);
            if (!this.compressContextTakeover) {
                this.compress.reset();
            }
        }
        outputBuffer.flip();
        return output;
    }

    private PooledByteBuffer largerBuffer(PooledByteBuffer smaller, WebSocketChannel channel, int newSize) {
        ByteBuffer smallerBuffer = smaller.getBuffer();
        smallerBuffer.flip();
        PooledByteBuffer larger = this.allocateBufferWithArray(channel, newSize);
        larger.getBuffer().put(smallerBuffer);
        smaller.close();
        return larger;
    }

    private PooledByteBuffer allocateBufferWithArray(WebSocketChannel channel, int size) {
        if (size > 0) {
            return new ImmediatePooledByteBuffer(ByteBuffer.allocate(size));
        }
        PooledByteBuffer pooled = channel.getBufferPool().allocate();
        if (pooled.getBuffer().hasArray()) {
            return pooled;
        }
        int pooledSize = pooled.getBuffer().remaining();
        pooled.close();
        return this.allocateBufferWithArray(channel, pooledSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PooledByteBuffer transformForRead(PooledByteBuffer pooledBuffer, WebSocketChannel wsChannel, boolean lastFragmentOfMessage) throws IOException {
        ByteBuffer buffer;
        StreamSourceFrameChannel channel = wsChannel.getExtensionSourceChannel();
        if ((channel.getRsv() & 4) == 0) {
            return pooledBuffer;
        }
        PooledByteBuffer output = this.allocateBufferWithArray(channel.getWebSocketChannel(), 0);
        if (this.currentReadChannel != null && this.currentReadChannel != channel) {
            this.decompress.setInput(TAIL);
            output = this.decompress(channel.getWebSocketChannel(), output);
        }
        if ((buffer = pooledBuffer.getBuffer()).hasArray()) {
            this.decompress.setInput(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            this.decompress.setInput(Buffers.take((ByteBuffer)buffer));
        }
        try {
            output = this.decompress(channel.getWebSocketChannel(), output);
        }
        finally {
            pooledBuffer.close();
        }
        if (lastFragmentOfMessage) {
            this.decompress.setInput(TAIL);
            output = this.decompress(channel.getWebSocketChannel(), output);
            this.currentReadChannel = null;
        } else {
            this.currentReadChannel = channel;
        }
        output.getBuffer().flip();
        return output;
    }

    private PooledByteBuffer decompress(WebSocketChannel channel, PooledByteBuffer pooled) throws IOException {
        ByteBuffer buffer = pooled.getBuffer();
        while (!this.decompress.needsInput() && !this.decompress.finished()) {
            int n;
            if (!buffer.hasRemaining()) {
                pooled = this.largerBuffer(pooled, channel, buffer.capacity() * 2);
                buffer = pooled.getBuffer();
            }
            try {
                n = this.decompress.inflate(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            }
            catch (DataFormatException e) {
                WebSocketLogger.EXTENSION_LOGGER.debug(e.getMessage(), e);
                throw WebSocketMessages.MESSAGES.badCompressedPayload(e);
            }
            buffer.position(buffer.position() + n);
        }
        return pooled;
    }

    @Override
    public void dispose() {
        this.compress.end();
        this.decompress.end();
    }
}

