/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.UndertowMessages;
import io.undertow.security.api.SessionNonceManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.FlexBase64;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;

public class SimpleNonceManager
implements SessionNonceManager {
    private static final String DEFAULT_HASH_ALG = "MD5";
    private final Set<String> invalidNonces = Collections.synchronizedSet(new HashSet());
    private final Map<String, Nonce> knownNonces = Collections.synchronizedMap(new HashMap());
    private final Map<NonceHolder, String> forwardMapping = Collections.synchronizedMap(new WeakHashMap());
    private final Random random = new Random();
    private final String secret;
    private final String hashAlg;
    private final int hashLength;
    private static final long firstUseTimeOut = 300000L;
    private static final long overallTimeOut = 900000L;
    private static final long cacheTimePostExpiry = 300000L;

    public SimpleNonceManager() {
        this(DEFAULT_HASH_ALG);
    }

    public SimpleNonceManager(String hashAlg) {
        MessageDigest digest = this.getDigest(hashAlg);
        this.hashAlg = hashAlg;
        this.hashLength = digest.getDigestLength();
        SecureRandom rand = new SecureRandom();
        byte[] secretBytes = new byte[32];
        ((Random)rand).nextBytes(secretBytes);
        this.secret = FlexBase64.encodeString(digest.digest(secretBytes), false);
    }

    private MessageDigest getDigest(String hashAlg) {
        try {
            return MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw UndertowMessages.MESSAGES.hashAlgorithmNotFound(hashAlg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nextNonce(String lastNonce, HttpServerExchange exchange) {
        if (lastNonce == null) {
            return this.createNewNonceString();
        }
        if (this.invalidNonces.contains(lastNonce)) {
            return this.createNewNonceString();
        }
        String nonce = lastNonce;
        Map<NonceHolder, String> map = this.forwardMapping;
        synchronized (map) {
            NonceHolder holder = new NonceHolder(lastNonce);
            while (this.forwardMapping.containsKey(holder)) {
                nonce = this.forwardMapping.get(holder);
                holder = new NonceHolder(nonce);
            }
            Map<String, Nonce> map2 = this.knownNonces;
            synchronized (map2) {
                Nonce value = this.knownNonces.get(nonce);
                if (value == null) {
                    nonce = this.createNewNonceString();
                } else {
                    long now = System.currentTimeMillis();
                    long earliestAccepted = now - 300000L;
                    if (value.timeStamp < earliestAccepted || value.timeStamp > now) {
                        XnioIoThread executor = exchange.getIoThread();
                        Nonce replacement = this.createNewNonce(holder);
                        if (value.executorKey != null) {
                            value.executorKey.remove();
                        }
                        nonce = replacement.nonce;
                        this.forwardMapping.put(holder, nonce);
                        replacement.setSessionKey(value.getSessionKey());
                        this.knownNonces.remove(holder.nonce);
                        this.knownNonces.put(nonce, replacement);
                        earliestAccepted = now - 1200000L;
                        long timeTillExpiry = replacement.timeStamp - earliestAccepted;
                        replacement.executorKey = executor.executeAfter((Runnable)new KnownNonceCleaner(nonce), timeTillExpiry, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
        return nonce;
    }

    private String createNewNonceString() {
        return this.createNewNonce(null).nonce;
    }

    private Nonce createNewNonce(NonceHolder previousNonce) {
        byte[] prefix = new byte[8];
        this.random.nextBytes(prefix);
        long timeStamp = System.currentTimeMillis();
        byte[] now = Long.toString(timeStamp).getBytes(StandardCharsets.UTF_8);
        String nonce = this.createNonce(prefix, now);
        return new Nonce(nonce, timeStamp, previousNonce);
    }

    @Override
    public boolean validateNonce(String nonce, int nonceCount, HttpServerExchange exchange) {
        Nonce value;
        XnioIoThread executor = exchange.getIoThread();
        if (nonceCount < 0) {
            if (this.invalidNonces.contains(nonce)) {
                return false;
            }
        } else {
            if (this.knownNonces.containsKey(nonce)) {
                return this.validateNonceWithCount(new Nonce(nonce), nonceCount, (XnioExecutor)executor);
            }
            if (this.forwardMapping.containsKey(new NonceHolder(nonce))) {
                return false;
            }
        }
        if ((value = this.verifyUnknownNonce(nonce, nonceCount)) == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        long earliestAccepted = now - 300000L;
        if (value.timeStamp < earliestAccepted || value.timeStamp > now) {
            return false;
        }
        if (nonceCount < 0) {
            return this.addInvalidNonce(value, (XnioExecutor)executor);
        }
        return this.validateNonceWithCount(value, nonceCount, (XnioExecutor)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateNonceWithCount(Nonce nonce, int nonceCount, XnioExecutor executor) {
        Map<String, Nonce> map = this.knownNonces;
        synchronized (map) {
            Nonce value = this.knownNonces.get(nonce.nonce);
            long now = System.currentTimeMillis();
            long earliestAccepted = now - 1200000L;
            if (value == null) {
                if (nonce.timeStamp < 0L) {
                    return false;
                }
                if (nonce.timeStamp > earliestAccepted && nonce.timeStamp <= now) {
                    this.knownNonces.put(nonce.nonce, nonce);
                    long timeTillExpiry = nonce.timeStamp - earliestAccepted;
                    nonce.executorKey = executor.executeAfter((Runnable)new KnownNonceCleaner(nonce.nonce), timeTillExpiry, TimeUnit.MILLISECONDS);
                    return true;
                }
                return false;
            }
            if (value.timeStamp < earliestAccepted || value.timeStamp > now) {
                return false;
            }
            if (value.getMaxNonceCount() < nonceCount) {
                value.setMaxNonceCount(nonceCount);
                return true;
            }
            return false;
        }
    }

    private boolean addInvalidNonce(Nonce nonce, XnioExecutor executor) {
        long now = System.currentTimeMillis();
        long invalidBefore = now - 300000L;
        long timeTillInvalid = nonce.timeStamp - invalidBefore;
        if (timeTillInvalid > 0L) {
            if (this.invalidNonces.add(nonce.nonce)) {
                executor.executeAfter((Runnable)new InvalidNonceCleaner(nonce.nonce), timeTillInvalid, TimeUnit.MILLISECONDS);
                return true;
            }
            return false;
        }
        return false;
    }

    private Nonce verifyUnknownNonce(String nonce, int nonceCount) {
        int length;
        int offset;
        byte[] complete;
        try {
            ByteBuffer decode = FlexBase64.decode(nonce);
            complete = decode.array();
            offset = decode.arrayOffset();
            length = decode.limit() - offset;
        }
        catch (IOException e) {
            throw UndertowMessages.MESSAGES.invalidBase64Token(e);
        }
        byte timeStampLength = complete[offset + 8];
        if (this.hashLength > 0) {
            int expectedLength = 9 + timeStampLength + this.hashLength;
            if (length != expectedLength) {
                throw UndertowMessages.MESSAGES.invalidNonceReceived();
            }
            if (timeStampLength + 1 >= length) {
                throw UndertowMessages.MESSAGES.invalidNonceReceived();
            }
        }
        byte[] prefix = new byte[8];
        System.arraycopy(complete, offset, prefix, 0, 8);
        byte[] timeStampBytes = new byte[timeStampLength];
        System.arraycopy(complete, offset + 9, timeStampBytes, 0, timeStampBytes.length);
        String expectedNonce = this.createNonce(prefix, timeStampBytes);
        if (expectedNonce.equals(nonce)) {
            try {
                long timeStamp = Long.parseLong(new String(timeStampBytes, StandardCharsets.UTF_8));
                return new Nonce(expectedNonce, timeStamp, nonceCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private String createNonce(byte[] prefix, byte[] timeStamp) {
        byte[] hashedPart = this.generateHash(prefix, timeStamp);
        byte[] complete = new byte[9 + timeStamp.length + hashedPart.length];
        System.arraycopy(prefix, 0, complete, 0, 8);
        complete[8] = (byte)timeStamp.length;
        System.arraycopy(timeStamp, 0, complete, 9, timeStamp.length);
        System.arraycopy(hashedPart, 0, complete, 9 + timeStamp.length, hashedPart.length);
        return FlexBase64.encodeString(complete, false);
    }

    private byte[] generateHash(byte[] prefix, byte[] timeStamp) {
        MessageDigest digest = this.getDigest(this.hashAlg);
        digest.update(prefix);
        digest.update(timeStamp);
        return digest.digest(this.secret.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void associateHash(String nonce, byte[] hash) {
    }

    @Override
    public byte[] lookupHash(String nonce) {
        return null;
    }

    private class KnownNonceCleaner
    implements Runnable {
        private final String nonce;

        private KnownNonceCleaner(String nonce) {
            if (nonce == null) {
                throw new NullPointerException("nonce must not be null.");
            }
            this.nonce = nonce;
        }

        @Override
        public void run() {
            SimpleNonceManager.this.knownNonces.remove(this.nonce);
        }
    }

    private class InvalidNonceCleaner
    implements Runnable {
        private final String nonce;

        private InvalidNonceCleaner(String nonce) {
            if (nonce == null) {
                throw new NullPointerException("nonce must not be null.");
            }
            this.nonce = nonce;
        }

        @Override
        public void run() {
            SimpleNonceManager.this.invalidNonces.remove(this.nonce);
        }
    }

    private static class Nonce {
        private final String nonce;
        private final long timeStamp;
        private int maxNonceCount;
        private final NonceHolder previousNonce;
        private byte[] sessionKey;
        private XnioExecutor.Key executorKey;

        private Nonce(String nonce) {
            this(nonce, -1L, -1);
        }

        private Nonce(String nonce, long timeStamp) {
            this(nonce, timeStamp, -1);
        }

        private Nonce(String nonce, long timeStamp, int initialNC) {
            this(nonce, timeStamp, initialNC, (NonceHolder)null);
        }

        private Nonce(String nonce, long timeStamp, NonceHolder previousNonce) {
            this(nonce, timeStamp, -1, previousNonce);
        }

        private Nonce(String nonce, long timeStamp, int initialNC, NonceHolder previousNonce) {
            this.nonce = nonce;
            this.timeStamp = timeStamp;
            this.maxNonceCount = initialNC;
            this.previousNonce = previousNonce;
        }

        byte[] getSessionKey() {
            return this.sessionKey;
        }

        void setSessionKey(byte[] sessionKey) {
            this.sessionKey = sessionKey;
        }

        int getMaxNonceCount() {
            return this.maxNonceCount;
        }

        void setMaxNonceCount(int maxNonceCount) {
            this.maxNonceCount = maxNonceCount;
        }
    }

    private static class NonceHolder {
        private final String nonce;

        private NonceHolder(String nonce) {
            if (nonce == null) {
                throw new NullPointerException("nonce must not be null.");
            }
            this.nonce = nonce;
        }

        public int hashCode() {
            return this.nonce.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof NonceHolder ? this.nonce.equals(((NonceHolder)obj).nonce) : false;
        }
    }
}

