/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.predicate.Predicates;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.impl.CachedAuthenticatedSessionMechanism;
import io.undertow.security.impl.FormAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FormAuthTestCase
extends AuthenticationTestBase {
    public static final String HELLO_WORLD = "Hello World";

    @Override
    protected void setRootHandler(HttpHandler current) {
        PredicateHandler handler = new PredicateHandler(Predicates.path((String)"/login"), new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("Login Page");
            }
        }, current);
        super.setRootHandler((HttpHandler)new SessionAttachmentHandler((HttpHandler)handler, (SessionManager)new InMemorySessionManager("test"), (SessionConfig)new SessionCookieConfig()));
    }

    @Override
    protected boolean cachingRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormAuth() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                Header[] locationHeaders = response.getHeaders("Location");
                if (locationHeaders != null && locationHeaders.length > 0) {
                    for (Header locationHeader : locationHeaders) {
                        Assert.assertFalse((String)"Location header incorrectly computed resulting in wrong request URI upon redirect, failed probably due UNDERTOW-884", (boolean)locationHeader.getValue().startsWith(DefaultServer.getDefaultServerURL() + DefaultServer.getDefaultServerURL()));
                    }
                }
                if (response.getStatusLine().getStatusCode() == 302) {
                    return true;
                }
                return super.isRedirected(request, response, context);
            }
        });
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/secured/test";
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Login Page", (Object)response);
            BasicNameValuePair[] pairs = new BasicNameValuePair[]{new BasicNameValuePair("j_username", "userOne"), new BasicNameValuePair("j_password", "passwordOne")};
            ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
            data.addAll(Arrays.asList(pairs));
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/j_security_check;jsessionid=dsjahfklsahdfjklsa");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(data));
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] values = result.getHeaders("ProcessedBy");
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Override
    protected List<AuthenticationMechanism> getTestMechanisms() {
        ArrayList<AuthenticationMechanism> ret = new ArrayList<AuthenticationMechanism>();
        ret.add((AuthenticationMechanism)new CachedAuthenticatedSessionMechanism());
        ret.add((AuthenticationMechanism)new FormAuthenticationMechanism("test", "/login", "/error"));
        return ret;
    }
}

