/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.impl.GenericHeaderAuthenticationMechanism;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class GenericHeaderAuthenticationTestCase
extends AuthenticationTestBase {
    static AuthenticationMechanism getTestMechanism() {
        return new GenericHeaderAuthenticationMechanism("GENERIC_HEADER", Collections.singletonList(new HttpString("user")), Collections.singletonList("sessionid"), identityManager);
    }

    @Override
    protected List<AuthenticationMechanism> getTestMechanisms() {
        AuthenticationMechanism mechanism = GenericHeaderAuthenticationTestCase.getTestMechanism();
        return Collections.singletonList(mechanism);
    }

    @Test
    public void testGenericHeaderSucess() throws Exception {
        GenericHeaderAuthenticationTestCase._testGenericHeaderSucess();
        GenericHeaderAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }

    static void _testGenericHeaderSucess() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse((HttpResponse)result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader("user", "userOne");
        get.addHeader("cookie", "sessionid=passwordOne");
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        HttpClientUtils.readResponse((HttpResponse)result);
    }

    @Test
    public void testBadUserName() throws Exception {
        GenericHeaderAuthenticationTestCase._testBadUserName();
        GenericHeaderAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    static void _testBadUserName() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse((HttpResponse)result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader("user", "badUser");
        get.addHeader("cookie", "sessionid=badPassword");
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse((HttpResponse)result);
    }

    @Test
    public void testBadPassword() throws Exception {
        GenericHeaderAuthenticationTestCase._testBadPassword();
        GenericHeaderAuthenticationTestCase.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    static void _testBadPassword() throws Exception {
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse((HttpResponse)result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader("user", "userOne");
        get.addHeader("cookie", "sessionid=badPassword");
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse((HttpResponse)result);
    }
}

