/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.ajp.AjpOpenListener;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.GSSAPIServerSubjectFactory;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.FormAuthenticationMechanism;
import io.undertow.security.impl.GSSAPIAuthenticationMechanism;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpOpenListener;
import io.undertow.server.OpenListener;
import io.undertow.server.handlers.CookieHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import io.undertow.server.handlers.form.FormEncodedDataHandler;
import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.core.handler.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.impl.WebSocketSessionConnectionCallback;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.SslConnection;
import org.xnio.ssl.XnioSsl;

public class Undertow {
    private final int bufferSize;
    private final int buffersPerRegion;
    private final int ioThreads;
    private final int workerThreads;
    private final int cacheSize;
    private final boolean directBuffers;
    private final List<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
    private final List<VirtualHost> hosts = new ArrayList<VirtualHost>();
    private XnioWorker worker;
    private List<AcceptingChannel<? extends StreamConnection>> channels;
    private Xnio xnio;

    private Undertow(Builder builder) {
        this.bufferSize = builder.bufferSize;
        this.buffersPerRegion = builder.buffersPerRegion;
        this.ioThreads = builder.ioThreads;
        this.workerThreads = builder.workerThreads;
        this.cacheSize = builder.cacheSize;
        this.directBuffers = builder.directBuffers;
        this.listeners.addAll(builder.listeners);
        this.hosts.addAll(builder.hosts);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VirtualHost virtualHost(String name) {
        return new VirtualHost(false).addHostName(name);
    }

    public static LoginConfig loginConfig(IdentityManager identityManager) {
        return new LoginConfig(identityManager);
    }

    public synchronized void start() {
        this.xnio = Xnio.getInstance("nio", Undertow.class.getClassLoader());
        this.channels = new ArrayList<AcceptingChannel<? extends StreamConnection>>();
        try {
            this.worker = this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, this.workerThreads).set(Options.WORKER_TASK_MAX_THREADS, this.workerThreads).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
            OptionMap serverOptions = OptionMap.builder().set(Options.WORKER_IO_THREADS, this.ioThreads).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
            ByteBufferSlicePool buffers = new ByteBufferSlicePool(this.directBuffers ? BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR : BufferAllocator.BYTE_BUFFER_ALLOCATOR, this.bufferSize, this.bufferSize * this.buffersPerRegion);
            HttpHandler rootHandler = this.buildHandlerChain();
            for (ListenerConfig listener : this.listeners) {
                AcceptingChannel<StreamConnection> server;
                ChannelListener<AcceptingChannel<StreamConnection>> acceptListener;
                OpenListener openListener;
                if (listener.type == ListenerType.AJP) {
                    openListener = new AjpOpenListener(buffers, this.bufferSize);
                    ((AjpOpenListener)openListener).setRootHandler(rootHandler);
                    acceptListener = ChannelListeners.openListenerAdapter(openListener);
                    server = this.worker.createStreamConnectionServer(new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, serverOptions);
                    server.resumeAccepts();
                    this.channels.add(server);
                    continue;
                }
                if (listener.type == ListenerType.HTTP) {
                    openListener = new HttpOpenListener(buffers, OptionMap.create(UndertowOptions.BUFFER_PIPELINED_DATA, true), this.bufferSize);
                    ((HttpOpenListener)openListener).setRootHandler(rootHandler);
                    acceptListener = ChannelListeners.openListenerAdapter(openListener);
                    server = this.worker.createStreamConnectionServer(new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, serverOptions);
                    server.resumeAccepts();
                    this.channels.add(server);
                    continue;
                }
                if (listener.type != ListenerType.HTTPS) continue;
                openListener = new HttpOpenListener(buffers, OptionMap.create(UndertowOptions.BUFFER_PIPELINED_DATA, true), this.bufferSize);
                ((HttpOpenListener)openListener).setRootHandler(rootHandler);
                acceptListener = ChannelListeners.openListenerAdapter(openListener);
                XnioSsl xnioSsl = this.xnio.getSslProvider(OptionMap.create(Options.USE_DIRECT_BUFFERS, true));
                AcceptingChannel<SslConnection> sslServer = xnioSsl.createSslConnectionServer(this.worker, new InetSocketAddress(Inet4Address.getByName(listener.host), listener.port), acceptListener, serverOptions);
                sslServer.resumeAccepts();
                this.channels.add(sslServer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void stop() {
        for (AcceptingChannel<? extends StreamConnection> channel : this.channels) {
            IoUtils.safeClose(channel);
        }
        this.channels = null;
        this.worker.shutdownNow();
        this.worker = null;
        this.xnio = null;
    }

    private HttpHandler buildHandlerChain() {
        NameVirtualHostHandler virtualHostHandler = new NameVirtualHostHandler();
        for (VirtualHost host : this.hosts) {
            PathHandler paths = new PathHandler();
            paths.addPath("/", host.defaultHandler);
            for (Map.Entry entry : host.handlers.entrySet()) {
                paths.addPath((String)entry.getKey(), (HttpHandler)entry.getValue());
            }
            HttpHandler handler = paths;
            for (HandlerWrapper wrapper : host.wrappers) {
                handler = wrapper.wrap(handler);
            }
            handler = Undertow.addLoginConfig(handler, host.loginConfig);
            if (host.defaultHost) {
                virtualHostHandler.setDefaultHandler(handler);
            }
            for (String hostName : host.hostNames) {
                virtualHostHandler.addHost(hostName, handler);
            }
        }
        HttpHandler root = virtualHostHandler;
        root = new CookieHandler(root);
        root = new FormEncodedDataHandler(root);
        root = new SimpleErrorPageHandler(root);
        if (this.cacheSize > 0) {
            root = new CacheHandler(new DirectBufferCache(1024, 0x100000, this.cacheSize * 1024 * 1024), root);
        }
        return root;
    }

    private static HttpHandler addLoginConfig(HttpHandler toWrap, LoginConfig config) {
        if (config == null) {
            return toWrap;
        }
        HttpHandler handler = toWrap;
        handler = new AuthenticationCallHandler(handler);
        handler = new AuthenticationConstraintHandler(handler);
        ArrayList<AuthenticationMechanism> mechanisms = new ArrayList<AuthenticationMechanism>();
        if (config.basic) {
            mechanisms.add(new BasicAuthenticationMechanism(config.realmName));
        }
        if (config.kerberos) {
            mechanisms.add(new GSSAPIAuthenticationMechanism(config.subjectFactory));
        }
        if (config.form) {
            mechanisms.add(new FormAuthenticationMechanism("FORM", config.loginPage, config.errorPage));
        }
        handler = new AuthenticationMechanismsHandler(handler, mechanisms);
        handler = new SecurityInitialHandler(config.authenticationMode, config.identityManager, handler);
        return handler;
    }

    public static final class Builder
    implements Host<Builder> {
        private int bufferSize;
        private int buffersPerRegion;
        private int ioThreads;
        private int workerThreads;
        private boolean directBuffers;
        private int cacheSize;
        private final List<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
        private final List<VirtualHost> hosts = new ArrayList<VirtualHost>();
        private final VirtualHost defaultHost = new VirtualHost(true);

        private Builder() {
            this.ioThreads = Runtime.getRuntime().availableProcessors();
            this.workerThreads = this.ioThreads * 8;
            long maxMemory = Runtime.getRuntime().maxMemory();
            if (maxMemory < 0x4000000L) {
                this.directBuffers = false;
                this.bufferSize = 512;
                this.buffersPerRegion = 10;
            } else if (maxMemory < 0x8000000L) {
                this.directBuffers = true;
                this.bufferSize = 1024;
                this.buffersPerRegion = 10;
            } else {
                this.directBuffers = true;
                this.bufferSize = 4096;
                this.buffersPerRegion = 20;
            }
            this.hosts.add(this.defaultHost);
        }

        public Undertow build() {
            return new Undertow(this);
        }

        public Builder enableCache(int cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public Builder addListener(int port, String host) {
            this.listeners.add(new ListenerConfig(ListenerType.HTTP, port, host));
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setBuffersPerRegion(int buffersPerRegion) {
            this.buffersPerRegion = buffersPerRegion;
            return this;
        }

        public Builder setIoThreads(int ioThreads) {
            this.ioThreads = ioThreads;
            return this;
        }

        public Builder setWorkerThreads(int workerThreads) {
            this.workerThreads = workerThreads;
            return this;
        }

        public Builder setDirectBuffers(boolean directBuffers) {
            this.directBuffers = directBuffers;
            return this;
        }

        public Builder addVirtualHost(String hostName) {
            VirtualHost host = new VirtualHost(false);
            host.addHostName(hostName);
            this.hosts.add(host);
            return this;
        }

        @Override
        public Builder addPathHandler(String path, HttpHandler handler) {
            this.defaultHost.addPathHandler(path, handler);
            return this;
        }

        @Override
        public Builder addWebSocketHandler(String path, WebSocketSessionHandler handler) {
            this.defaultHost.addWebSocketHandler(path, handler);
            return this;
        }

        @Override
        public Builder setDefaultHandler(HttpHandler handler) {
            this.defaultHost.setDefaultHandler(handler);
            return this;
        }

        @Override
        public Builder addHandlerWrapper(HandlerWrapper wrapper) {
            this.defaultHost.addHandlerWrapper(wrapper);
            return this;
        }

        @Override
        public Builder setLoginConfig(LoginConfig loginConfig) {
            this.defaultHost.setLoginConfig(loginConfig);
            return this;
        }
    }

    public static class LoginConfig {
        private final IdentityManager identityManager;
        private boolean basic;
        private boolean digest;
        private boolean kerberos;
        private boolean form;
        private String realmName;
        private String errorPage;
        private String loginPage;
        private GSSAPIServerSubjectFactory subjectFactory;
        private AuthenticationMode authenticationMode = AuthenticationMode.PRO_ACTIVE;

        public LoginConfig(IdentityManager identityManager) {
            this.identityManager = identityManager;
        }

        public LoginConfig basicAuth(String realmName) {
            if (this.digest) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("basic", "digest");
            }
            if (this.form) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("basic", "form");
            }
            this.basic = true;
            this.realmName = realmName;
            return this;
        }

        public LoginConfig digestAuth(String realmName) {
            if (this.basic) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("digest", "basic");
            }
            if (this.form) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("digest", "form");
            }
            this.digest = true;
            this.realmName = realmName;
            return this;
        }

        public LoginConfig kerberosAuth(GSSAPIServerSubjectFactory subjectFactory) {
            this.kerberos = true;
            this.subjectFactory = subjectFactory;
            return this;
        }

        public LoginConfig formAuth(String loginPage, String errorPage) {
            if (this.digest) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("form", "digest");
            }
            if (this.basic) {
                throw UndertowMessages.MESSAGES.authTypeCannotBeCombined("form", "basic");
            }
            this.loginPage = loginPage;
            this.errorPage = errorPage;
            this.form = true;
            return this;
        }

        public LoginConfig setAuthenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }
    }

    public static class VirtualHost
    implements Host<VirtualHost> {
        private final List<String> hostNames = new ArrayList<String>();
        private final Map<String, HttpHandler> handlers = new HashMap<String, HttpHandler>();
        private final List<HandlerWrapper> wrappers = new ArrayList<HandlerWrapper>();
        private final boolean defaultHost;
        private LoginConfig loginConfig;
        private HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;

        VirtualHost(boolean defaultHost) {
            this.defaultHost = defaultHost;
        }

        public VirtualHost addHostName(String hostName) {
            this.hostNames.add(hostName);
            return this;
        }

        @Override
        public VirtualHost addPathHandler(String path, HttpHandler handler) {
            this.handlers.put(path, handler);
            return this;
        }

        @Override
        public VirtualHost addWebSocketHandler(String path, WebSocketSessionHandler handler) {
            this.handlers.put(path, new WebSocketProtocolHandshakeHandler(new WebSocketSessionConnectionCallback(handler)));
            return this;
        }

        @Override
        public VirtualHost setDefaultHandler(HttpHandler handler) {
            this.defaultHandler = handler;
            return this;
        }

        @Override
        public VirtualHost addHandlerWrapper(HandlerWrapper wrapper) {
            this.wrappers.add(wrapper);
            return this;
        }

        @Override
        public VirtualHost setLoginConfig(LoginConfig loginConfig) {
            this.loginConfig = loginConfig;
            return this;
        }
    }

    public static interface Host<T> {
        public T addPathHandler(String var1, HttpHandler var2);

        public T addWebSocketHandler(String var1, WebSocketSessionHandler var2);

        public T setDefaultHandler(HttpHandler var1);

        public T addHandlerWrapper(HandlerWrapper var1);

        public T setLoginConfig(LoginConfig var1);
    }

    private static class ListenerConfig {
        final ListenerType type;
        final int port;
        final String host;

        private ListenerConfig(ListenerType type, int port, String host) {
            this.type = type;
            this.port = port;
            this.host = host;
        }
    }

    public static enum ListenerType {
        HTTP,
        HTTPS,
        AJP;

    }
}

