/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.HttpClientConnectionImpl;
import io.undertow.client.HttpClientOptions;
import io.undertow.client.HttpRequestQueueImpl;
import io.undertow.client.PendingHttpRequest;
import io.undertow.util.Protocols;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Deque;
import org.xnio.OptionMap;

abstract class HttpRequestQueueStrategy {
    private final HttpClientConnectionImpl connection;

    static HttpRequestQueueStrategy create(HttpClientConnectionImpl connection, OptionMap options) {
        boolean http11 = Protocols.HTTP_1_1.equals(options.get(HttpClientOptions.PROTOCOL, Protocols.HTTP_1_1));
        boolean pipeline = options.get(HttpClientOptions.HTTP_PIPELINING, false);
        if (http11 && pipeline) {
            return new PipelineStrategy(connection);
        }
        return new SingleActiveStrategy(connection);
    }

    protected HttpRequestQueueStrategy(HttpClientConnectionImpl connection) {
        this.connection = connection;
    }

    abstract void addNewRequest(PendingHttpRequest var1);

    abstract void requestSent(PendingHttpRequest var1);

    abstract void requestCompleted(PendingHttpRequest var1);

    abstract boolean supportsPipelining();

    protected void sendRequest(PendingHttpRequest request, boolean fromCallback) {
        this.connection.doSendRequest(request, fromCallback);
    }

    protected void readResponse(PendingHttpRequest request) {
        this.connection.doReadResponse(request);
    }

    static abstract class HttpRequestQueue<E>
    extends AbstractCollection<E>
    implements Deque<E>,
    Serializable {
        HttpRequestQueue() {
        }

        abstract boolean addAndCheckFirst(E var1);

        abstract E removeAndPeekNext();
    }

    static class PipelineStrategy
    extends HttpRequestQueueStrategy {
        private final HttpRequestQueue<PendingHttpRequest> sendQueue = new HttpRequestQueueImpl<PendingHttpRequest>();
        private final HttpRequestQueue<PendingHttpRequest> responseQueue = new HttpRequestQueueImpl<PendingHttpRequest>();

        PipelineStrategy(HttpClientConnectionImpl connection) {
            super(connection);
        }

        @Override
        void addNewRequest(PendingHttpRequest request) {
            if (this.sendQueue.addAndCheckFirst(request)) {
                this.sendRequest(request, false);
            }
        }

        @Override
        void requestSent(PendingHttpRequest request) {
            PendingHttpRequest send = this.sendQueue.removeAndPeekNext();
            if (this.responseQueue.addAndCheckFirst(request)) {
                this.readResponse(request);
            }
            if (send != null && request.allowPipeline()) {
                this.sendRequest(send, true);
            }
        }

        @Override
        void requestCompleted(PendingHttpRequest request) {
            PendingHttpRequest send;
            PendingHttpRequest read = this.responseQueue.removeAndPeekNext();
            if (read != null) {
                this.readResponse(read);
            }
            if (!request.allowPipeline() && (send = (PendingHttpRequest)this.sendQueue.peek()) != null) {
                this.sendRequest(send, true);
            }
        }

        @Override
        boolean supportsPipelining() {
            return true;
        }
    }

    static class SingleActiveStrategy
    extends HttpRequestQueueStrategy {
        private final HttpRequestQueue<PendingHttpRequest> requestQueue = new HttpRequestQueueImpl<PendingHttpRequest>();

        SingleActiveStrategy(HttpClientConnectionImpl connection) {
            super(connection);
        }

        @Override
        void addNewRequest(PendingHttpRequest request) {
            if (this.requestQueue.addAndCheckFirst(request)) {
                this.sendRequest(request, false);
            }
        }

        @Override
        void requestSent(PendingHttpRequest request) {
            assert (request == this.requestQueue.peek());
            this.readResponse(request);
        }

        @Override
        void requestCompleted(PendingHttpRequest request) {
            PendingHttpRequest send = this.requestQueue.removeAndPeekNext();
            if (send != null) {
                this.sendRequest(send, true);
            }
        }

        @Override
        boolean supportsPipelining() {
            return false;
        }
    }
}

