/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import org.xnio.IoUtils;

public class URLResource
implements Resource {
    private final URL url;
    private final URLConnection connection;

    public URLResource(URL url, URLConnection connection) {
        this.url = url;
        this.connection = connection;
    }

    @Override
    public Date getLastModified() {
        return new Date(this.connection.getLastModified());
    }

    @Override
    public String getLastModifiedString() {
        return DateUtils.toDateString(this.getLastModified());
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        int sepIndex;
        String path = this.url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 2);
        }
        if ((sepIndex = path.lastIndexOf("/")) != -1) {
            path = path.substring(sepIndex + 1);
        }
        return path;
    }

    @Override
    public boolean isDirectory() {
        Path file = this.getFile();
        if (file != null) {
            return Files.isDirectory(file, new LinkOption[0]);
        }
        return false;
    }

    @Override
    public List<Resource> list() {
        return null;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    @Override
    public void serve(final HttpServerExchange exchange) {
        class ServerTask
        implements Runnable,
        IoCallback {
            private InputStream inputStream;
            private byte[] buffer;
            private Sender sender;

            ServerTask() {
            }

            @Override
            public void run() {
                if (this.inputStream == null) {
                    try {
                        this.inputStream = URLResource.this.url.openStream();
                    }
                    catch (IOException e) {
                        exchange.setResponseCode(500);
                        return;
                    }
                    this.buffer = new byte[1024];
                    this.sender = exchange.getResponseSender();
                }
                try {
                    int res = this.inputStream.read(this.buffer);
                    if (res == -1) {
                        this.sender.close();
                        return;
                    }
                    this.sender.send(ByteBuffer.wrap(this.buffer, 0, res), (IoCallback)this);
                }
                catch (IOException e) {
                    this.onException(exchange, this.sender, e);
                }
            }

            @Override
            public void onComplete(HttpServerExchange exchange2, Sender sender) {
                if (exchange2.isInIoThread()) {
                    exchange2.dispatch(this);
                } else {
                    this.run();
                }
            }

            @Override
            public void onException(HttpServerExchange exchange2, Sender sender, IOException exception) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                IoUtils.safeClose((Closeable)this.inputStream);
                if (!exchange2.isResponseStarted()) {
                    exchange2.setResponseCode(500);
                }
                exchange2.endExchange();
            }
        }
        ServerTask serveTask = new ServerTask();
        if (exchange.isInIoThread()) {
            exchange.dispatch(serveTask);
        } else {
            serveTask.run();
        }
    }

    @Override
    public Long getContentLength() {
        return this.connection.getContentLength();
    }

    @Override
    public Resource getIndexResource(List<String> possible) {
        return null;
    }

    @Override
    public String getCacheKey() {
        return this.url.toString();
    }

    @Override
    public Path getFile() {
        if (this.url.getProtocol().equals("file")) {
            try {
                return Paths.get(this.url.toURI());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }
}

