/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Deque;

public class PathParameterSessionConfig
implements SessionConfig {
    private String name = "JSESSIONID";

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        Deque<String> stringDeque = exchange.getPathParameters().get(this.name);
        if (stringDeque == null) {
            return null;
        }
        return stringDeque.getFirst();
    }

    @Override
    public String rewriteUrl(String originalUrl, Session session) {
        try {
            int pos = originalUrl.indexOf("?");
            if (pos != -1) {
                return originalUrl.substring(0, pos) + ";" + this.name + "=" + URLEncoder.encode(session.getId(), "UTF-8") + originalUrl.substring(pos);
            }
            return originalUrl + ";" + this.name + "=" + URLEncoder.encode(session.getId(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

