/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.io.BlockingSenderImpl;
import io.undertow.io.Sender;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.core.BlockingWriterSenderImpl;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletBlockingHttpExchange
implements BlockingHttpExchange {
    private final HttpServerExchange exchange;
    private Sender sender;

    public ServletBlockingHttpExchange(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public InputStream getInputStream() {
        ServletRequest request = this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getServletRequest();
        try {
            return request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        ServletResponse response = this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getServletResponse();
        try {
            return response.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Sender getSender() {
        if (this.sender == null) {
            try {
                this.sender = new BlockingSenderImpl(this.exchange, this.getOutputStream());
            }
            catch (IllegalStateException e) {
                ServletResponse response = this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getServletResponse();
                try {
                    this.sender = new BlockingWriterSenderImpl(this.exchange, response.getWriter(), response.getCharacterEncoding());
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return this.sender;
    }

    @Override
    public void close() throws IOException {
        if (!this.exchange.isComplete()) {
            ServletRequestContext attachments = this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            HttpServletRequestImpl request = attachments.getOriginalRequest();
            request.closeAndDrainRequest();
            HttpServletResponseImpl response = attachments.getOriginalResponse();
            response.closeStreamAndWriter();
        }
    }
}

