/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.impl.FormAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletFormAuthenticationMechanism
extends FormAuthenticationMechanism {
    public ServletFormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        super(name, loginPage, errorPage);
    }

    public ServletFormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        super(name, loginPage, errorPage, postLocation);
    }

    @Override
    protected Integer servePage(HttpServerExchange exchange, String location) {
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest req = servletRequestContext.getServletRequest();
        ServletResponse resp = servletRequestContext.getServletResponse();
        RequestDispatcher disp = req.getRequestDispatcher(location);
        try {
            disp.forward(req, resp);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    protected void storeInitialLocation(HttpServerExchange exchange) {
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse resp = (HttpServletResponse)servletRequestContext.getServletResponse();
        Cookie cookie = new Cookie("FORM_AUTH_ORIGINAL_URL", req.getContextPath() + req.getServletPath() + (req.getPathInfo() == null ? "" : req.getPathInfo()));
        cookie.setPath(req.getServletContext().getContextPath());
        resp.addCookie(cookie);
    }

    @Override
    protected void handleRedirectBack(HttpServerExchange exchange) {
        Cookie[] cookies;
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse resp = (HttpServletResponse)servletRequestContext.getServletResponse();
        for (Cookie cookie : cookies = req.getCookies()) {
            if (!cookie.getName().equals("FORM_AUTH_ORIGINAL_URL")) continue;
            try {
                resp.sendRedirect(cookie.getValue());
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

