/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.util;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ConstructorInstanceFactory<T>
implements InstanceFactory<T> {
    private final Constructor<T> constructor;

    public ConstructorInstanceFactory(Constructor<T> constructor) {
        constructor.setAccessible(true);
        this.constructor = constructor;
    }

    @Override
    public InstanceHandle<T> createInstance() throws InstantiationException {
        try {
            T instance = this.constructor.newInstance(new Object[0]);
            return new ImmediateInstanceHandle<T>(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

