/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.FragmentedTextFrameSender;
import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.core.FragmentedMessageChannel;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.impl.DefaultTextFrameSender;
import io.undertow.websockets.impl.StreamSinkChannelUtils;
import io.undertow.websockets.impl.WebSocketChannelSession;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.channels.BlockingWritableByteChannel;
import org.xnio.channels.StreamSinkChannel;

final class DefaultFragmentedTextFrameSender
extends DefaultTextFrameSender
implements FragmentedTextFrameSender {
    private FragmentedMessageChannel channel;
    private boolean finalFragment;

    public DefaultFragmentedTextFrameSender(WebSocketChannelSession session) {
        super(session);
    }

    @Override
    protected StreamSinkFrameChannel createSink(long payloadSize) throws IOException {
        if (this.session.closeFrameSent) {
            WebSocketMessages.MESSAGES.closeFrameSentBefore();
        }
        if (this.channel == null) {
            this.channel = this.session.getChannel().sendFragmentedText();
        }
        StreamSinkFrameChannel sink = this.channel.send(payloadSize, this.finalFragment);
        return sink;
    }

    @Override
    public void finalFragment() {
        this.finalFragment = true;
    }

    @Override
    public void sendText(ByteBuffer payload, SendCallback callback) {
        try {
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(payload.remaining()));
            StreamSinkChannelUtils.send(sink, payload, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    @Override
    public void sendText(ByteBuffer[] payload, SendCallback callback) {
        try {
            long length = StreamSinkChannelUtils.payloadLength(payload);
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(length));
            StreamSinkChannelUtils.send(sink, payload, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    @Override
    public void sendText(ByteBuffer payload) throws IOException {
        this.checkBlockingAllowed();
        StreamSinkFrameChannel sink = this.createSink(payload.remaining());
        BlockingWritableByteChannel channel = new BlockingWritableByteChannel(sink);
        while (payload.hasRemaining()) {
            channel.write(payload);
        }
        sink.shutdownWrites();
        channel.flush();
        channel.close();
    }

    @Override
    public void sendText(ByteBuffer[] payload) throws IOException {
        this.checkBlockingAllowed();
        long length = StreamSinkChannelUtils.payloadLength(payload);
        StreamSinkFrameChannel sink = this.createSink(length);
        BlockingWritableByteChannel channel = new BlockingWritableByteChannel(sink);
        long written = 0L;
        while (written < length) {
            long w = channel.write(payload);
            if (w <= 0L) continue;
            written += w;
        }
        sink.shutdownWrites();
        channel.flush();
        channel.close();
    }
}

