/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.PongFrameSender;
import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.impl.AbstractSender;
import io.undertow.websockets.impl.StreamSinkChannelUtils;
import io.undertow.websockets.impl.WebSocketChannelSession;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.channels.StreamSinkChannel;

final class DefaultPongFrameSender
extends AbstractSender
implements PongFrameSender {
    DefaultPongFrameSender(WebSocketChannelSession session) {
        super(session);
    }

    @Override
    protected WebSocketFrameType type() {
        return WebSocketFrameType.PONG;
    }

    @Override
    public void sendPong(ByteBuffer payload, SendCallback callback) {
        try {
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(payload.remaining()));
            StreamSinkChannelUtils.send(sink, payload, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    @Override
    public void sendPong(ByteBuffer[] payload, SendCallback callback) {
        try {
            long length = StreamSinkChannelUtils.payloadLength(payload);
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(length));
            StreamSinkChannelUtils.send(sink, payload, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    @Override
    public void sendPong(ByteBuffer payload) throws IOException {
        this.checkBlockingAllowed();
        StreamSinkChannel sink = this.createSink(payload.remaining());
        StreamSinkChannelUtils.send(sink, payload);
    }

    @Override
    public void sendPong(ByteBuffer[] payload) throws IOException {
        this.checkBlockingAllowed();
        long length = StreamSinkChannelUtils.payloadLength(payload);
        StreamSinkChannel sink = this.createSink(length);
        StreamSinkChannelUtils.send(sink, payload);
    }
}

